/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.cloudsdk;

import com.google.cloud.tools.appengine.operations.AppCfg;
import com.google.cloud.tools.appengine.operations.AppEngineWebXmlProjectStaging;
import com.google.cloud.tools.appengine.operations.AppYamlProjectStaging;
import com.google.cloud.tools.appengine.operations.Auth;
import com.google.cloud.tools.appengine.operations.CloudSdk;
import com.google.cloud.tools.appengine.operations.Deployment;
import com.google.cloud.tools.appengine.operations.DevServer;
import com.google.cloud.tools.appengine.operations.DevServers;
import com.google.cloud.tools.appengine.operations.Gcloud;
import com.google.cloud.tools.appengine.operations.GenRepoInfoFile;
import com.google.cloud.tools.appengine.operations.cloudsdk.AppEngineJavaComponentsNotInstalledException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkNotFoundException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkOutOfDateException;
import com.google.cloud.tools.appengine.operations.cloudsdk.CloudSdkVersionFileException;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.LegacyProcessHandler;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.NonZeroExceptionExitListener;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessExitListener;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessHandler;
import com.google.cloud.tools.appengine.operations.cloudsdk.process.ProcessOutputLineListener;
import com.google.cloud.tools.managedcloudsdk.components.SdkComponent;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkChecker;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkDownloader;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import com.google.cloud.tools.maven.cloudsdk.ConfigReader;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;

public class CloudSdkAppEngineFactory {
    private final CloudSdkMojo mojo;

    public CloudSdkAppEngineFactory(CloudSdkMojo mojo) {
        this.mojo = mojo;
    }

    public Auth auth() {
        return this.getGcloud().newAuth(this.newDefaultProcessHandler());
    }

    public AppEngineWebXmlProjectStaging appengineWebXmlStaging() {
        return this.getAppCfg().newStaging(this.newDefaultProcessHandler());
    }

    public AppYamlProjectStaging appYamlStaging() {
        return new AppYamlProjectStaging();
    }

    public Deployment deployment() {
        return this.getGcloud().newDeployment(this.newDefaultProcessHandler());
    }

    public DevServer devServerRunSync() {
        return this.getDevServers().newDevAppServer(this.newDefaultProcessHandler());
    }

    public DevServer devServerRunAsync(int startSuccessTimeout) {
        return this.getDevServers().newDevAppServer(this.newDevAppServerAsyncHandler(startSuccessTimeout));
    }

    public DevServer devServerStop() {
        return this.getDevServers().newDevAppServer(this.newDefaultProcessHandler());
    }

    public GenRepoInfoFile genRepoInfoFile() {
        return this.getGcloud().newGenRepoInfo(this.newDefaultProcessHandler());
    }

    private CloudSdk buildCloudSdkMinimal() {
        return CloudSdkAppEngineFactory.buildCloudSdk(this.mojo, new CloudSdkChecker(), new CloudSdkDownloader(CloudSdkDownloader.newManagedSdkFactory()), false);
    }

    @VisibleForTesting
    CloudSdk buildCloudSdkWithAppEngineComponents() {
        return CloudSdkAppEngineFactory.buildCloudSdk(this.mojo, new CloudSdkChecker(), new CloudSdkDownloader(CloudSdkDownloader.newManagedSdkFactory()), true);
    }

    static CloudSdk buildCloudSdk(CloudSdkMojo mojo, CloudSdkChecker cloudSdkChecker, CloudSdkDownloader cloudSdkDownloader, boolean requiresAppEngineComponents) {
        try {
            if (mojo.getCloudSdkHome() != null) {
                CloudSdk cloudSdk = new CloudSdk.Builder().sdkPath(mojo.getCloudSdkHome()).build();
                if (mojo.getCloudSdkVersion() != null) {
                    cloudSdkChecker.checkCloudSdk(cloudSdk, mojo.getCloudSdkVersion());
                }
                if (requiresAppEngineComponents) {
                    cloudSdkChecker.checkForAppEngine(cloudSdk);
                }
                return cloudSdk;
            }
            ArrayList<SdkComponent> requiredComponents = new ArrayList<SdkComponent>();
            if (requiresAppEngineComponents) {
                requiredComponents.add(SdkComponent.APP_ENGINE_JAVA);
            }
            return new CloudSdk.Builder().sdkPath(cloudSdkDownloader.downloadIfNecessary(mojo.getCloudSdkVersion(), mojo.getLog(), requiredComponents, mojo.getMavenSession().isOffline())).build();
        }
        catch (AppEngineJavaComponentsNotInstalledException | CloudSdkNotFoundException | CloudSdkOutOfDateException | CloudSdkVersionFileException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Gcloud getGcloud() {
        return Gcloud.builder((CloudSdk)this.buildCloudSdkMinimal()).setMetricsEnvironment(this.mojo.getArtifactId(), this.mojo.getArtifactVersion()).setCredentialFile(this.mojo.getServiceAccountKeyFile()).build();
    }

    private AppCfg getAppCfg() {
        return AppCfg.builder((CloudSdk)this.buildCloudSdkWithAppEngineComponents()).build();
    }

    private DevServers getDevServers() {
        return DevServers.builder((CloudSdk)this.buildCloudSdkWithAppEngineComponents()).build();
    }

    private ProcessHandler newDefaultProcessHandler() {
        DefaultProcessOutputLineListener lineListener = new DefaultProcessOutputLineListener(this.mojo.getLog());
        return LegacyProcessHandler.builder().addStdOutLineListener((ProcessOutputLineListener)lineListener).addStdErrLineListener((ProcessOutputLineListener)lineListener).setExitListener((ProcessExitListener)new NonZeroExceptionExitListener()).build();
    }

    private ProcessHandler newDevAppServerAsyncHandler(int timeout) {
        Path logDir = Paths.get(this.mojo.getMavenProject().getBuild().getDirectory(), new String[0]).resolve("dev-appserver-out");
        if (!Files.exists(logDir, new LinkOption[0])) {
            try {
                logDir = Files.createDirectories(logDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create dev-appserver logging directory.");
            }
        }
        File logFile = logDir.resolve("dev_appserver.out").toFile();
        FileOutputLineListener fileListener = new FileOutputLineListener(logFile);
        this.mojo.getLog().info((CharSequence)("Dev App Server output written to : " + logFile));
        DefaultProcessOutputLineListener lineListener = new DefaultProcessOutputLineListener(this.mojo.getLog());
        return LegacyProcessHandler.builder().addStdOutLineListener((ProcessOutputLineListener)lineListener).addStdOutLineListener((ProcessOutputLineListener)fileListener).addStdErrLineListener((ProcessOutputLineListener)lineListener).addStdErrLineListener((ProcessOutputLineListener)fileListener).setExitListener((ProcessExitListener)new NonZeroExceptionExitListener()).buildDevAppServerAsync(timeout);
    }

    public ConfigReader newConfigReader() {
        return new ConfigReader(this.getGcloud());
    }

    static class FileOutputLineListener
    implements ProcessOutputLineListener {
        private final PrintStream logFilePrinter;

        FileOutputLineListener(File logFile) {
            try {
                this.logFilePrinter = new PrintStream(logFile, StandardCharsets.UTF_8.name());
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        logFilePrinter.close();
                    }
                });
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void onOutputLine(String line) {
            this.logFilePrinter.println(line);
        }
    }

    static class DefaultProcessOutputLineListener
    implements ProcessOutputLineListener {
        private final Log log;

        DefaultProcessOutputLineListener(Log log) {
            this.log = log;
        }

        public void onOutputLine(String line) {
            this.log.info((CharSequence)("GCLOUD: " + line));
        }
    }
}

