/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.genrepoinfo;

import com.google.cloud.tools.appengine.AppEngineException;
import com.google.cloud.tools.appengine.configuration.GenRepoInfoFileConfiguration;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import java.io.File;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="genRepoInfoFile")
@Execute(phase=LifecyclePhase.PREPARE_PACKAGE)
public class GenRepoInfoFileMojo
extends CloudSdkMojo {
    private static Logger logger = Logger.getLogger(GenRepoInfoFileMojo.class.getName());
    private static final String HOW_TO_FIX_MSG = "An error occurred while generating source context files. Make sure your project is in a Git repository. To ignore source context generation errors, use the -Dapp.genRepoInfoFile.ignoreErrors=true flag.";
    @Parameter(alias="genRepoInfoFile.sourceDirectory", defaultValue="${project.basedir}", property="app.genRepoInfoFile.sourceDirectory")
    protected File sourceDirectory;
    @Parameter(alias="genRepoInfoFile.outputDirectory", defaultValue="${project.build.outputDirectory}", property="app.genRepoInfoFile.outputDirectory")
    protected File outputDirectory;
    @Parameter(alias="genRepoInfoFile.ignoreErrors", defaultValue="false", property="app.genRepoInfoFile.ignoreErrors")
    protected boolean ignoreErrors;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping appengine:genRepoInfoFile");
            return;
        }
        try {
            this.getAppEngineFactory().genRepoInfoFile().generate(GenRepoInfoFileConfiguration.builder().outputDirectory(this.outputDirectory == null ? null : this.outputDirectory.toPath()).sourceDirectory(this.sourceDirectory == null ? null : this.sourceDirectory.toPath()).build());
        }
        catch (AppEngineException aee) {
            if (!this.ignoreErrors) {
                throw new MojoExecutionException(HOW_TO_FIX_MSG, (Exception)((Object)aee));
            }
            logger.warning(HOW_TO_FIX_MSG);
        }
    }
}

