/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.stage;

import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractStageMojo
extends CloudSdkMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/appengine-staging", alias="stage.stagingDirectory", property="app.stage.stagingDirectory")
    File stagingDirectory;
    @Parameter(alias="stage.dockerfile", property="app.stage.dockerfile")
    private File dockerfile;
    @Parameter(required=true, defaultValue="${project.build.directory}/${project.build.finalName}", alias="stage.sourceDirectory", property="app.stage.sourceDirectory")
    private File sourceDirectory;
    @Parameter(alias="stage.enableQuickstart", property="app.stage.enableQuickstart")
    private boolean enableQuickstart;
    @Parameter(alias="stage.enableJarSplitting", property="app.stage.enableJarSplitting")
    private boolean enableJarSplitting;
    @Parameter(alias="stage.jarSplittingExcludes", property="app.stage.jarSplittingExcludes")
    private String jarSplittingExcludes;
    @Parameter(alias="stage.compileEncoding", property="app.stage.compileEncoding")
    private String compileEncoding;
    @Parameter(alias="stage.deleteJsps", property="app.stage.deleteJsps")
    private boolean deleteJsps;
    @Parameter(alias="stage.disableJarJsps", property="app.stage.disableJarJsps")
    private boolean disableJarJsps;
    @Parameter(alias="stage.enableJarClasses", property="app.stage.enableJarClasses")
    private boolean enableJarClasses;
    private boolean disableUpdateCheck = true;
    @Parameter(defaultValue="${basedir}/src/main/docker/Dockerfile", readonly=true)
    private File dockerfilePrimaryDefaultLocation;
    @Parameter(defaultValue="${basedir}/src/main/appengine/Dockerfile", readonly=true)
    private File dockerfileSecondaryDefaultLocation;
    @Parameter(defaultValue="${basedir}/src/main/appengine", alias="stage.appEngineDirectory", property="app.stage.appEngineDirectory")
    private File appEngineDirectory;
    @Parameter(alias="stage.extraFilesDirectories", property="app.stage.extraFilesDirectories")
    private List<File> extraFilesDirectories;
    @Parameter(defaultValue="${basedir}/src/main/docker/", alias="stage.dockerDirectory", property="app.stage.dockerDirectory")
    private File dockerDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", alias="stage.artifact", property="app.stage.artifact")
    private File artifact;

    public boolean isAppEngineCompatiblePackaging() {
        return ImmutableList.of((Object)"jar", (Object)"war").contains((Object)this.getMavenProject().getPackaging());
    }

    public boolean isAppEngineWebXmlBased() {
        return Files.exists(this.getAppEngineWebXml(), new LinkOption[0]);
    }

    public Path getAppEngineWebXml() {
        return this.getSourceDirectory().resolve("WEB-INF").resolve("appengine-web.xml");
    }

    public Path getStagingDirectory() {
        return this.stagingDirectory.toPath();
    }

    public Path getDockerfile() {
        return this.dockerfile == null ? null : this.dockerfile.toPath();
    }

    public Path getSourceDirectory() {
        return this.sourceDirectory.toPath();
    }

    public boolean isEnableQuickstart() {
        return this.enableQuickstart;
    }

    public boolean isEnableJarSplitting() {
        return this.enableJarSplitting;
    }

    public String getJarSplittingExcludes() {
        return this.jarSplittingExcludes;
    }

    public String getCompileEncoding() {
        return this.compileEncoding;
    }

    public boolean isDeleteJsps() {
        return this.deleteJsps;
    }

    public boolean isDisableJarJsps() {
        return this.disableJarJsps;
    }

    public boolean isEnableJarClasses() {
        return this.enableJarClasses;
    }

    public boolean isDisableUpdateCheck() {
        return this.disableUpdateCheck;
    }

    public Path getDockerfilePrimaryDefaultLocation() {
        return this.dockerfilePrimaryDefaultLocation.toPath();
    }

    public Path getDockerfileSecondaryDefaultLocation() {
        return this.dockerfileSecondaryDefaultLocation.toPath();
    }

    public Path getAppEngineDirectory() {
        return this.appEngineDirectory == null ? null : this.appEngineDirectory.toPath();
    }

    public List<Path> getExtraFilesDirectories() {
        return this.extraFilesDirectories == null ? null : this.extraFilesDirectories.stream().map(File::toPath).collect(Collectors.toList());
    }

    public Path getDockerDirectory() {
        return this.dockerDirectory == null ? null : this.dockerDirectory.toPath();
    }

    public Path getArtifact() {
        return this.artifact == null ? null : this.artifact.toPath();
    }
}

