/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.run;

import com.google.cloud.tools.maven.cloudsdk.CloudSdkMojo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractRunMojo
extends CloudSdkMojo {
    @Parameter(alias="devserver.services", property="app.devserver.services", required=true)
    private List<File> services;
    @Parameter(alias="devserver.host", property="app.devserver.host")
    private String host;
    @Parameter(alias="devserver.port", property="app.devserver.port")
    private Integer port;
    @Parameter(alias="devserver.jvmFlags", property="app.devserver.jvmFlags")
    private List<String> jvmFlags;
    @Parameter(alias="devserver.automaticRestart", property="app.devserver.automaticRestart")
    private Boolean automaticRestart;
    @Parameter(alias="devserver.defaultGcsBucketName", property="app.devserver.defaultGcsBucketName")
    private String defaultGcsBucketName;
    @Parameter(alias="devserver.environment", property="app.devserver.environment")
    private Map<String, String> environment;
    @Parameter(alias="devserver.additionalArguments", property="app.devserver.additionalArguments")
    private List<String> additionalArguments;
    @Parameter(alias="devserver.projectId", property="app.devserver.projectId")
    private String projectId;

    public List<Path> getServices() {
        if (this.services == null || this.services.isEmpty()) {
            Build build = this.getMavenProject().getBuild();
            return Collections.singletonList(Paths.get(build.getDirectory(), new String[0]).resolve(build.getFinalName()));
        }
        return this.services.stream().map(File::toPath).collect(Collectors.toList());
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public List<String> getJvmFlags() {
        return this.jvmFlags;
    }

    public Boolean getAutomaticRestart() {
        return this.automaticRestart;
    }

    public String getDefaultGcsBucketName() {
        return this.defaultGcsBucketName;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public List<String> getAdditionalArguments() {
        return this.additionalArguments;
    }

    public String getProjectId() {
        return this.projectId;
    }
}

