/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.cloudsdk;

import com.google.cloud.tools.managedcloudsdk.BadCloudSdkVersionException;
import com.google.cloud.tools.managedcloudsdk.ConsoleListener;
import com.google.cloud.tools.managedcloudsdk.ManagedCloudSdk;
import com.google.cloud.tools.managedcloudsdk.ManagedSdkVerificationException;
import com.google.cloud.tools.managedcloudsdk.ManagedSdkVersionMismatchException;
import com.google.cloud.tools.managedcloudsdk.ProgressListener;
import com.google.cloud.tools.managedcloudsdk.UnsupportedOsException;
import com.google.cloud.tools.managedcloudsdk.Version;
import com.google.cloud.tools.managedcloudsdk.command.CommandExecutionException;
import com.google.cloud.tools.managedcloudsdk.command.CommandExitException;
import com.google.cloud.tools.managedcloudsdk.components.SdkComponent;
import com.google.cloud.tools.managedcloudsdk.install.SdkInstallerException;
import com.google.cloud.tools.maven.cloudsdk.CloudSdkDownloaderConsoleListener;
import com.google.cloud.tools.maven.cloudsdk.NoOpProgressListener;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import org.apache.maven.plugin.logging.Log;

public class CloudSdkDownloader {
    private final Function<String, ManagedCloudSdk> managedCloudSdkFactory;

    public CloudSdkDownloader(Function<String, ManagedCloudSdk> managedCloudSdkFactory) {
        this.managedCloudSdkFactory = managedCloudSdkFactory;
    }

    public Path downloadIfNecessary(String version, Log log, List<SdkComponent> components, boolean offline) {
        ManagedCloudSdk managedCloudSdk = this.managedCloudSdkFactory.apply(version);
        if (offline) {
            return managedCloudSdk.getSdkHome();
        }
        try {
            NoOpProgressListener progressListener = new NoOpProgressListener();
            CloudSdkDownloaderConsoleListener consoleListener = new CloudSdkDownloaderConsoleListener(log);
            if (!managedCloudSdk.isInstalled()) {
                managedCloudSdk.newInstaller().install((ProgressListener)progressListener, (ConsoleListener)consoleListener);
            }
            if (components != null) {
                for (SdkComponent component : components) {
                    if (managedCloudSdk.hasComponent(component)) continue;
                    managedCloudSdk.newComponentInstaller().installComponent(component, (ProgressListener)progressListener, (ConsoleListener)consoleListener);
                }
            }
            if (!managedCloudSdk.isUpToDate()) {
                managedCloudSdk.newUpdater().update((ProgressListener)progressListener, (ConsoleListener)consoleListener);
            }
            return managedCloudSdk.getSdkHome();
        }
        catch (ManagedSdkVerificationException | ManagedSdkVersionMismatchException | CommandExecutionException | CommandExitException | SdkInstallerException | IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Function<String, ManagedCloudSdk> newManagedSdkFactory() {
        return version -> {
            try {
                if (Strings.isNullOrEmpty((String)version)) {
                    return ManagedCloudSdk.newManagedSdk();
                }
                return ManagedCloudSdk.newManagedSdk((Version)new Version(version));
            }
            catch (BadCloudSdkVersionException | UnsupportedOsException ex) {
                throw new RuntimeException(ex);
            }
        };
    }
}

