/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.run;

import com.google.cloud.tools.appengine.AppEngineException;
import com.google.cloud.tools.appengine.configuration.RunConfiguration;
import com.google.cloud.tools.maven.run.AbstractRunMojo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class Runner {
    private final AbstractRunMojo runMojo;
    private final ConfigBuilder configBuilder;
    static final String NON_STANDARD_APPLICATION_ERROR = "\nCould not find appengine-web.xml all services, perhaps you need to run 'mvn package appengine:run/start'.\nDev App Server only supports appengine-web.xml based Java applications.";

    Runner(AbstractRunMojo runMojo, ConfigBuilder configBuilder) {
        this.runMojo = runMojo;
        this.configBuilder = configBuilder;
    }

    public void run() throws MojoExecutionException {
        try {
            this.runMojo.getAppEngineFactory().devServerRunSync().run(this.configBuilder.buildRunConfiguration(this.processServices(), this.processProjectId()));
        }
        catch (AppEngineException ex) {
            throw new MojoExecutionException("Failed to run devappserver", (Exception)((Object)ex));
        }
    }

    public void runAsync(int startSuccessTimeout) throws MojoExecutionException {
        this.runMojo.getLog().info((CharSequence)("Waiting " + startSuccessTimeout + " seconds for the Dev App Server to start."));
        try {
            this.runMojo.getAppEngineFactory().devServerRunAsync(startSuccessTimeout).run(this.configBuilder.buildRunConfiguration(this.processServices(), this.processProjectId()));
        }
        catch (AppEngineException ex) {
            throw new RuntimeException(ex);
        }
        this.runMojo.getLog().info((CharSequence)"Dev App Server started.");
        this.runMojo.getLog().info((CharSequence)"Use the 'mvn appengine:stop' command to stop the server.");
    }

    @VisibleForTesting
    List<Path> processServices() throws MojoExecutionException {
        List<Path> services = this.runMojo.getServices();
        Preconditions.checkState((services != null ? 1 : 0) != 0, (Object)"'services' is null");
        Preconditions.checkState((!services.isEmpty() ? 1 : 0) != 0, (Object)"'services' is empty");
        for (Path service : services) {
            if (Files.exists(service.resolve("WEB-INF").resolve("appengine-web.xml"), new LinkOption[0])) continue;
            throw new MojoExecutionException(NON_STANDARD_APPLICATION_ERROR);
        }
        return services;
    }

    String processProjectId() {
        String projectId = this.runMojo.getProjectId();
        if ("GCLOUD_CONFIG".equals(projectId)) {
            return this.runMojo.getAppEngineFactory().newConfigReader().getProjectId();
        }
        return projectId;
    }

    static class ConfigBuilder {
        private final AbstractRunMojo runMojo;

        ConfigBuilder(AbstractRunMojo runMojo) {
            this.runMojo = runMojo;
        }

        protected RunConfiguration buildRunConfiguration(List<Path> services, String projectId) {
            return RunConfiguration.builder(services).additionalArguments(this.runMojo.getAdditionalArguments()).automaticRestart(this.runMojo.getAutomaticRestart()).defaultGcsBucketName(this.runMojo.getDefaultGcsBucketName()).projectId(projectId).environment(this.runMojo.getEnvironment()).host(this.runMojo.getHost()).jvmFlags(this.runMojo.getJvmFlags()).port(this.runMojo.getPort()).build();
        }
    }

    static class Factory {
        Factory() {
        }

        public Runner newRunner(AbstractRunMojo runMojo) throws MojoExecutionException {
            for (Path service : runMojo.getServices()) {
                if (Files.isRegularFile(service.resolve("WEB-INF").resolve("appengine-web.xml"), new LinkOption[0])) continue;
                throw new MojoExecutionException("appengine:run is only available for appengine-web.xml based projects, the service defined in: " + service.toString() + " cannot be run by the dev appserver.");
            }
            return new Runner(runMojo, new ConfigBuilder(runMojo));
        }
    }
}

