/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven.stage;

import com.google.cloud.tools.appengine.AppEngineException;
import com.google.cloud.tools.appengine.configuration.AppEngineWebXmlProjectStageConfiguration;
import com.google.cloud.tools.maven.stage.AbstractStageMojo;
import com.google.cloud.tools.maven.stage.Stager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AppEngineWebXmlStager
implements Stager {
    private final AbstractStageMojo stageMojo;
    private final ConfigBuilder configBuilder;

    public static AppEngineWebXmlStager newAppEngineWebXmlStager(AbstractStageMojo stageMojo) {
        return new AppEngineWebXmlStager(stageMojo, new ConfigBuilder(stageMojo));
    }

    AppEngineWebXmlStager(AbstractStageMojo stageMojo, ConfigBuilder configBuilder) {
        this.stageMojo = stageMojo;
        this.configBuilder = configBuilder;
    }

    @Override
    public void stage() throws MojoExecutionException {
        AppEngineWebXmlProjectStageConfiguration config = this.configBuilder.buildConfiguration();
        Path stagingDirectory = config.getStagingDirectory();
        this.stageMojo.getLog().info((CharSequence)("Staging the application to: " + stagingDirectory));
        this.stageMojo.getLog().info((CharSequence)"Detected App Engine appengine-web.xml based application.");
        if (Files.exists(stagingDirectory, new LinkOption[0])) {
            this.stageMojo.getLog().info((CharSequence)("Deleting the staging directory: " + stagingDirectory));
            try {
                FileUtils.deleteDirectory((File)stagingDirectory.toFile());
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Unable to delete staging directory.", (Exception)ex);
            }
        }
        if (!stagingDirectory.toFile().mkdir()) {
            throw new MojoExecutionException("Unable to create staging directory");
        }
        try {
            this.stageMojo.getAppEngineFactory().appengineWebXmlStaging().stageStandard(config);
        }
        catch (AppEngineException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class ConfigBuilder {
        private final AbstractStageMojo stageMojo;

        ConfigBuilder(AbstractStageMojo stageMojo) {
            this.stageMojo = stageMojo;
        }

        AppEngineWebXmlProjectStageConfiguration buildConfiguration() throws MojoExecutionException {
            return AppEngineWebXmlProjectStageConfiguration.builder((Path)this.stageMojo.getSourceDirectory(), (Path)this.stageMojo.getStagingDirectory()).compileEncoding(this.stageMojo.getCompileEncoding()).deleteJsps(Boolean.valueOf(this.stageMojo.isDeleteJsps())).disableJarJsps(Boolean.valueOf(this.stageMojo.isDisableJarJsps())).disableUpdateCheck(Boolean.valueOf(this.stageMojo.isDisableUpdateCheck())).dockerfile(this.processDockerfile()).enableJarClasses(Boolean.valueOf(this.stageMojo.isEnableJarClasses())).enableJarSplitting(Boolean.valueOf(this.stageMojo.isEnableJarSplitting())).enableQuickstart(Boolean.valueOf(this.stageMojo.isEnableQuickstart())).jarSplittingExcludes(this.stageMojo.getJarSplittingExcludes()).runtime(this.processRuntime()).build();
        }

        Path processDockerfile() {
            if (this.stageMojo.getDockerfile() == null) {
                if (this.stageMojo.getDockerfilePrimaryDefaultLocation() != null && Files.exists(this.stageMojo.getDockerfilePrimaryDefaultLocation(), new LinkOption[0])) {
                    return this.stageMojo.getDockerfilePrimaryDefaultLocation();
                }
                if (this.stageMojo.getDockerfileSecondaryDefaultLocation() != null && Files.exists(this.stageMojo.getDockerfileSecondaryDefaultLocation(), new LinkOption[0])) {
                    return this.stageMojo.getDockerfileSecondaryDefaultLocation();
                }
            }
            return this.stageMojo.getDockerfile();
        }

        String processRuntime() throws MojoExecutionException {
            Path appengineWebXml = this.stageMojo.getAppEngineWebXml();
            if (Float.parseFloat(this.stageMojo.getCompileTargetVersion()) > 1.7f && this.isVm(appengineWebXml)) {
                return "java";
            }
            return null;
        }

        private boolean isVm(Path appengineWebXml) throws MojoExecutionException {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(appengineWebXml.toFile());
                XPath xpath = XPathFactory.newInstance().newXPath();
                String expression = "/appengine-web-app/vm/text()='true'";
                return (Boolean)xpath.evaluate(expression, document, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException ex) {
                throw new MojoExecutionException("XPath evaluation failed on appengine-web.xml", (Exception)ex);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new MojoExecutionException("Failed to parse appengine-web.xml", ex);
            }
        }
    }
}

