/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.client;

import com.google.cloud.tools.gradle.endpoints.framework.client.EndpointsClientExtension;
import com.google.cloud.tools.gradle.endpoints.framework.client.task.ExtractDiscoveryDocZipsTask;
import com.google.cloud.tools.gradle.endpoints.framework.client.task.GenerateClientLibrariesTask;
import com.google.cloud.tools.gradle.endpoints.framework.client.task.GenerateClientLibrarySourceTask;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.AbstractCompile;

public class EndpointsClientPlugin
implements Plugin<Project> {
    public static final String GENERATE_CLIENT_LIBRARY_TASK = "_endpointsClientLibs";
    public static final String GENERATE_CLIENT_LIBRARY_SRC_TASK = "_endpointsClientGenSrc";
    public static final String EXTRACT_SERVER_DISCOVERY_DOCS_TASK = "_extractServerDiscoveryDocs";
    public static final String ENDPOINTS_CLIENT_EXTENSION = "endpointsClient";
    public static final String ENDPOINTS_SERVER_CONFIGURATION = "endpointsServer";
    private Project project;
    private EndpointsClientExtension extension;

    public void apply(Project project) {
        this.project = project;
        this.createExtension();
        this.createConfiguration();
        this.createExtractServerDiscoveryDocsTask();
        this.createGenerateClientLibTask();
        this.createGenerateClientLibSrcTask();
    }

    private void createExtension() {
        this.extension = (EndpointsClientExtension)this.project.getExtensions().create(ENDPOINTS_CLIENT_EXTENSION, EndpointsClientExtension.class, new Object[]{this.project});
    }

    private void createConfiguration() {
        ((Configuration)this.project.getConfigurations().create(ENDPOINTS_SERVER_CONFIGURATION)).setDescription("endpointsServer project(path: ':xyz', configuration: 'endpoints')").setVisible(false);
    }

    private void createExtractServerDiscoveryDocsTask() {
        this.project.getTasks().create(EXTRACT_SERVER_DISCOVERY_DOCS_TASK, ExtractDiscoveryDocZipsTask.class, (Action)new Action<ExtractDiscoveryDocZipsTask>(){

            public void execute(final ExtractDiscoveryDocZipsTask extractDiscoveryDocs) {
                extractDiscoveryDocs.setDescription("_internal");
                EndpointsClientPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        Set files = project.getConfigurations().getByName(EndpointsClientPlugin.ENDPOINTS_SERVER_CONFIGURATION).getFiles();
                        extractDiscoveryDocs.setDiscoveryDocZips(files);
                        extractDiscoveryDocs.setDiscoveryDocsDir(EndpointsClientPlugin.this.extension.getGenDiscoveryDocsDir());
                    }
                });
            }
        });
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().getByName(EndpointsClientPlugin.EXTRACT_SERVER_DISCOVERY_DOCS_TASK).dependsOn(new Object[]{project.getConfigurations().getByName(EndpointsClientPlugin.ENDPOINTS_SERVER_CONFIGURATION).getBuildDependencies()});
            }
        });
    }

    private void createGenerateClientLibTask() {
        this.project.getTasks().create(GENERATE_CLIENT_LIBRARY_TASK, GenerateClientLibrariesTask.class, (Action)new Action<GenerateClientLibrariesTask>(){

            public void execute(final GenerateClientLibrariesTask genClientLibs) {
                genClientLibs.setDescription("_internal");
                genClientLibs.dependsOn(new Object[]{EndpointsClientPlugin.EXTRACT_SERVER_DISCOVERY_DOCS_TASK});
                EndpointsClientPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        genClientLibs.setClientLibraryDir(EndpointsClientPlugin.this.extension.getClientLibDir());
                        genClientLibs.setDiscoveryDocs(EndpointsClientPlugin.this.extension.getDiscoveryDocs());
                        genClientLibs.setGeneratedDiscoveryDocs(EndpointsClientPlugin.this.extension.getGenDiscoveryDocsDir());
                    }
                });
            }
        });
    }

    private void createGenerateClientLibSrcTask() {
        this.project.getTasks().create(GENERATE_CLIENT_LIBRARY_SRC_TASK, GenerateClientLibrarySourceTask.class, (Action)new Action<GenerateClientLibrarySourceTask>(){

            public void execute(final GenerateClientLibrarySourceTask genClientLibSrc) {
                genClientLibSrc.setDescription("_internal");
                genClientLibSrc.dependsOn(new Object[]{EndpointsClientPlugin.GENERATE_CLIENT_LIBRARY_TASK});
                EndpointsClientPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        genClientLibSrc.setClientLibDir(EndpointsClientPlugin.this.extension.getClientLibDir());
                        genClientLibSrc.setGeneratedSrcDir(EndpointsClientPlugin.this.extension.getGenSrcDir());
                    }
                });
            }
        });
        if (this.project.getExtensions().findByName("android") != null) {
            this.project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)"com.google.cloud.tools.endpoints-framework-android-client"));
        } else {
            this.project.getTasks().withType(AbstractCompile.class, (Action)new Action<AbstractCompile>(){

                public void execute(AbstractCompile compile) {
                    compile.dependsOn(new Object[]{EndpointsClientPlugin.GENERATE_CLIENT_LIBRARY_SRC_TASK});
                }
            });
            JavaPluginConvention java = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSetContainer sourceSets = java.getSourceSets();
            SourceSet mainSrc = (SourceSet)sourceSets.getByName("main");
            mainSrc.getJava().srcDir((Object)this.extension.getGenSrcDir());
        }
    }
}

