/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.client.task;

import com.google.api.server.spi.tools.EndpointsTool;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateClientLibrariesTask
extends DefaultTask {
    private File clientLibraryDir;
    private List<File> discoveryDocs;
    private File generatedDiscoveryDocsDir;

    @OutputDirectory
    public File getClientLibraryDir() {
        return this.clientLibraryDir;
    }

    public void setClientLibraryDir(File clientLibraryDir) {
        this.clientLibraryDir = clientLibraryDir;
    }

    @InputFiles
    public List<File> getDiscoveryDocs() {
        return this.discoveryDocs;
    }

    public void setDiscoveryDocs(List<File> discoveryDocs) {
        ArrayList<File> expandedDiscoveryDocs = new ArrayList<File>();
        for (File discoveryDoc : discoveryDocs) {
            if (discoveryDoc.isDirectory()) {
                expandedDiscoveryDocs.addAll(GenerateClientLibrariesTask.findDiscoveryDocsInDirectory(discoveryDoc));
                continue;
            }
            expandedDiscoveryDocs.add(discoveryDoc);
        }
        this.discoveryDocs = expandedDiscoveryDocs;
    }

    @InputDirectory
    public File getGeneratedDiscoveryDocsDir() {
        return this.generatedDiscoveryDocsDir;
    }

    public void setGeneratedDiscoveryDocs(File generatedDiscoveryDocsDir) {
        this.generatedDiscoveryDocsDir = generatedDiscoveryDocsDir;
    }

    @TaskAction
    public void generateClientLibs() throws Exception {
        this.getProject().delete(new Object[]{this.clientLibraryDir});
        this.getProject().mkdir((Object)this.clientLibraryDir);
        for (File discoveryDoc : this.discoveryDocs) {
            this.runEndpointsTools(discoveryDoc);
        }
        for (File discoveryDoc : GenerateClientLibrariesTask.findDiscoveryDocsInDirectory(this.generatedDiscoveryDocsDir)) {
            this.runEndpointsTools(discoveryDoc);
        }
    }

    private void runEndpointsTools(File discoveryDoc) throws Exception {
        ArrayList params = Lists.newArrayList(Arrays.asList("gen-client-lib", "-l", "java", "-bs", "gradle", "-o", this.clientLibraryDir.getAbsolutePath()));
        params.add(discoveryDoc.getAbsolutePath());
        new EndpointsTool().execute(params.toArray(new String[params.size()]));
    }

    private static List<File> findDiscoveryDocsInDirectory(File discoveryDocDirectory) {
        Preconditions.checkArgument((boolean)discoveryDocDirectory.isDirectory());
        File[] discoveryDocs = discoveryDocDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".discovery");
            }
        });
        return Arrays.asList(discoveryDocs);
    }
}

