/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.client.task;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateClientLibrarySourceTask
extends DefaultTask {
    private File clientLibDir;
    private File generatedSrcDir;

    @OutputDirectory
    public File getGeneratedSrcDir() {
        return this.generatedSrcDir;
    }

    public void setGeneratedSrcDir(File generatedSrcDir) {
        this.generatedSrcDir = generatedSrcDir;
    }

    @InputDirectory
    public File getClientLibDir() {
        return this.clientLibDir;
    }

    public void setClientLibDir(File clientLibDir) {
        this.clientLibDir = clientLibDir;
    }

    @TaskAction
    public void generateSource() {
        boolean x = this.getProject().delete(new Object[]{this.generatedSrcDir});
        File[] zips = this.getClientLibDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".zip");
            }
        });
        final File tmpDir = new File(this.getTemporaryDir(), "endpoints-tmp");
        this.getProject().delete(new Object[]{tmpDir});
        this.getProject().mkdir((Object)tmpDir);
        for (final File zip : zips) {
            this.getAnt().invokeMethod("unzip", (Object)new HashMap<String, String>(){
                {
                    this.put("src", zip.getPath());
                    this.put("dest", tmpDir.getPath());
                }
            });
        }
        for (File unzippedDir : tmpDir.listFiles()) {
            final File srcDir = new File(unzippedDir, "src/main/java");
            if (!srcDir.exists() || !srcDir.isDirectory()) continue;
            this.getProject().copy((Action)new Action<CopySpec>(){

                public void execute(CopySpec copySpec) {
                    copySpec.from(new Object[]{srcDir});
                    copySpec.into((Object)GenerateClientLibrarySourceTask.this.generatedSrcDir);
                }
            });
        }
    }
}

