/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;

public class EndpointsServerExtension {
    private final Project project;
    private final File discoveryDocDir;
    private final File openApiDocDir;
    private File clientLibDir;
    private List<String> serviceClasses;
    private String hostname;
    private String basePath;

    public EndpointsServerExtension(Project project) {
        this.project = project;
        this.discoveryDocDir = new File(project.getBuildDir(), "endpointsDiscoveryDocs");
        this.openApiDocDir = new File(project.getBuildDir(), "endpointsOpenApiDocs");
        this.clientLibDir = new File(project.getBuildDir(), "endpointsClientLibs");
        this.serviceClasses = new ArrayList<String>();
    }

    public File getDiscoveryDocDir() {
        return this.discoveryDocDir;
    }

    public File getOpenApiDocDir() {
        return this.openApiDocDir;
    }

    public File getClientLibDir() {
        return this.clientLibDir;
    }

    public void setClientLibDir(Object clientLibDir) {
        this.clientLibDir = this.project.file(clientLibDir);
    }

    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public void setServiceClasses(List<String> serviceClasses) {
        this.serviceClasses = serviceClasses;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

