/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.server;

import com.google.cloud.tools.gradle.endpoints.framework.server.EndpointsServerExtension;
import com.google.cloud.tools.gradle.endpoints.framework.server.task.EndpointsArtifactTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Zip;

public class EndpointsServerPlugin
implements Plugin<Project> {
    public static final String GENERATE_OPENAPI_DOC_TASK = "endpointsOpenApiDocs";
    public static final String GENERATE_DISCOVERY_DOC_TASK = "endpointsDiscoveryDocs";
    public static final String GENERATE_CLINT_LIBS_TASK = "endpointsClientLibs";
    public static final String SERVER_EXTENSION = "endpointsServer";
    public static final String ARTIFACT_CONFIGURATION = "endpoints";
    private static final String APP_ENGINE_ENDPOINTS = "App Engine Endpoints";
    private Project project;
    private EndpointsServerExtension extension;

    public void apply(Project project) {
        this.project = project;
        this.createExtension();
        this.configureEndpointsArtifactTaskAdditionCallback();
        this.createDiscoverDocConfiguration();
        this.createGenerateDiscoveryDocsTask();
        this.createGenerateOpenApiDocsTask();
        this.createGenerateClientLibsTask();
    }

    private void createExtension() {
        this.extension = (EndpointsServerExtension)this.project.getExtensions().create(SERVER_EXTENSION, EndpointsServerExtension.class, new Object[]{this.project});
    }

    private void configureEndpointsArtifactTaskAdditionCallback() {
        this.project.getTasks().withType(EndpointsArtifactTask.class).whenTaskAdded((Action)new Action<EndpointsArtifactTask>(){

            public void execute(final EndpointsArtifactTask task) {
                final FileCollection classesDirs = ((SourceSet)((JavaPluginConvention)EndpointsServerPlugin.this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getClassesDirs();
                EndpointsServerPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        task.setClassesDirs(classesDirs);
                        task.setHostname(EndpointsServerPlugin.this.extension.getHostname());
                        task.setBasePath(EndpointsServerPlugin.this.extension.getBasePath());
                        task.setServiceClasses(EndpointsServerPlugin.this.extension.getServiceClasses());
                        task.setWebAppDir(((WarPluginConvention)project.getConvention().getPlugin(WarPluginConvention.class)).getWebAppDir());
                    }
                });
            }
        });
    }

    private void createDiscoverDocConfiguration() {
        this.project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getConfigurations().create(EndpointsServerPlugin.ARTIFACT_CONFIGURATION);
                Zip discoveryDocArchive = (Zip)project.getTasks().create("_zipDiscoveryDocs", Zip.class);
                discoveryDocArchive.dependsOn(new Object[]{EndpointsServerPlugin.GENERATE_DISCOVERY_DOC_TASK});
                discoveryDocArchive.from(new Object[]{EndpointsServerPlugin.this.extension.getDiscoveryDocDir()});
                discoveryDocArchive.setArchiveName(project.getName() + "-discoveryDocs.zip");
                project.getArtifacts().add(EndpointsServerPlugin.ARTIFACT_CONFIGURATION, (Object)discoveryDocArchive);
            }
        });
    }

    private void createGenerateDiscoveryDocsTask() {
        this.project.getTasks().create(GENERATE_DISCOVERY_DOC_TASK, EndpointsArtifactTask.class, (Action)new Action<EndpointsArtifactTask>(){

            public void execute(final EndpointsArtifactTask genDiscoveryDocs) {
                genDiscoveryDocs.setCommand("get-discovery-doc");
                genDiscoveryDocs.setDescription("Generate endpoints discovery documents");
                genDiscoveryDocs.setCleanBeforeRun(true);
                genDiscoveryDocs.setGroup(EndpointsServerPlugin.APP_ENGINE_ENDPOINTS);
                genDiscoveryDocs.dependsOn(new Object[]{"classes"});
                EndpointsServerPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        genDiscoveryDocs.setOutputDirectory(EndpointsServerPlugin.this.extension.getDiscoveryDocDir());
                    }
                });
            }
        });
    }

    private void createGenerateOpenApiDocsTask() {
        this.project.getTasks().create(GENERATE_OPENAPI_DOC_TASK, EndpointsArtifactTask.class, (Action)new Action<EndpointsArtifactTask>(){

            public void execute(final EndpointsArtifactTask genOpenApiDocs) {
                genOpenApiDocs.setCommand("get-openapi-doc");
                genOpenApiDocs.setDescription("Generate endpoints Open API documents");
                genOpenApiDocs.setCleanBeforeRun(true);
                genOpenApiDocs.setGroup(EndpointsServerPlugin.APP_ENGINE_ENDPOINTS);
                genOpenApiDocs.dependsOn(new Object[]{"classes"});
                genOpenApiDocs.setOutputFileName("openapi.json");
                EndpointsServerPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        genOpenApiDocs.setOutputDirectory(EndpointsServerPlugin.this.extension.getOpenApiDocDir());
                    }
                });
            }
        });
    }

    private void createGenerateClientLibsTask() {
        this.project.getTasks().create(GENERATE_CLINT_LIBS_TASK, EndpointsArtifactTask.class, (Action)new Action<EndpointsArtifactTask>(){

            public void execute(final EndpointsArtifactTask genClientLibs) {
                genClientLibs.setCommand("get-client-lib");
                genClientLibs.setDescription("Generate endpoints client libraries");
                genClientLibs.setCleanBeforeRun(false);
                genClientLibs.setOutputLanguage("java");
                genClientLibs.setOutputBuildSystem("gradle");
                genClientLibs.setGroup(EndpointsServerPlugin.APP_ENGINE_ENDPOINTS);
                genClientLibs.dependsOn(new Object[]{"classes"});
                EndpointsServerPlugin.this.project.afterEvaluate((Action)new Action<Project>(){

                    public void execute(Project project) {
                        genClientLibs.setOutputDirectory(EndpointsServerPlugin.this.extension.getClientLibDir());
                    }
                });
            }
        });
    }
}

