/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.gradle.endpoints.framework.server.task;

import com.google.api.server.spi.tools.EndpointsTool;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;

public class EndpointsArtifactTask
extends DefaultTask {
    private FileCollection classesDirs;
    private String command;
    private boolean cleanBeforeRun;
    private String outputLanguage;
    private String outputBuildSystem;
    private String outputFileName;
    private File outputDirectory;
    private String hostname;
    private String basePath;
    private List<String> serviceClasses;
    private File webAppDir;

    @InputFiles
    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }

    public void setClassesDirs(FileCollection classesDirs) {
        this.classesDirs = classesDirs;
    }

    @Internal
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @InputDirectory
    public File getWebAppDir() {
        return this.webAppDir;
    }

    public void setWebAppDir(File webAppDir) {
        this.webAppDir = webAppDir;
    }

    @Input
    public List<String> getServiceClasses() {
        return this.serviceClasses;
    }

    public void setServiceClasses(List<String> serviceClasses) {
        this.serviceClasses = serviceClasses;
    }

    @Optional
    @Input
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Optional
    @Input
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Internal
    public boolean isCleanBeforeRun() {
        return this.cleanBeforeRun;
    }

    public void setCleanBeforeRun(boolean cleanBeforeRun) {
        this.cleanBeforeRun = cleanBeforeRun;
    }

    @Internal
    public String getOutputLanguage() {
        return this.outputLanguage;
    }

    public void setOutputLanguage(String outputLanguage) {
        this.outputLanguage = outputLanguage;
    }

    @Internal
    public String getOutputBuildSystem() {
        return this.outputBuildSystem;
    }

    public void setOutputBuildSystem(String outputBuildSystem) {
        this.outputBuildSystem = outputBuildSystem;
    }

    @Internal
    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @TaskAction
    void generateEndpointsArtifact() throws Exception {
        if (this.cleanBeforeRun) {
            this.getProject().delete(new Object[]{this.outputDirectory});
            this.getProject().mkdir((Object)this.outputDirectory);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.command);
        params.add("-o");
        if (!Strings.isNullOrEmpty((String)this.outputFileName)) {
            params.add(new File(this.outputDirectory, this.outputFileName).getAbsolutePath());
        } else {
            params.add(this.outputDirectory.getAbsolutePath());
        }
        String classpath = ((SourceSet)((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath().getAsPath();
        params.add("-cp");
        params.add(classpath);
        params.add("-w");
        params.add(this.webAppDir.getAbsolutePath());
        if (!Strings.isNullOrEmpty((String)this.outputBuildSystem)) {
            params.add("-bs");
            params.add(this.outputBuildSystem);
        }
        if (!Strings.isNullOrEmpty((String)this.outputLanguage)) {
            params.add("-l");
            params.add(this.outputLanguage);
        }
        if (!Strings.isNullOrEmpty((String)this.hostname)) {
            params.add("-h");
            params.add(this.hostname);
        }
        if (!Strings.isNullOrEmpty((String)this.basePath)) {
            params.add("-p");
            params.add(this.basePath);
        }
        params.addAll(this.serviceClasses);
        new EndpointsTool().execute(params.toArray(new String[params.size()]));
    }
}

