/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.cloud.tools.jib.registry;

import java.io.IOException;
import java.net.MalformedURLException;

/** Static initializers for {@link RegistryAuthenticator}. */
public abstract class RegistryAuthenticators {

  public static RegistryAuthenticator forDockerHub(String repository)
      throws RegistryAuthenticationFailedException {
    try {
      return new RegistryAuthenticator(
          "https://auth.docker.io/token", "registry.docker.io", repository);

    } catch (MalformedURLException ex) {
      throw new RegistryAuthenticationFailedException(ex);
    }
  }

  public static RegistryAuthenticator forOther(String serverUrl, String repository)
      throws RegistryAuthenticationFailedException, IOException, RegistryException {
    try {
      RegistryClient registryClient = new RegistryClient(null, serverUrl, repository);
      return registryClient.getRegistryAuthenticator();

    } catch (MalformedURLException ex) {
      throw new RegistryAuthenticationFailedException(ex);
    }
  }
}
