/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticators;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.IOException;
import java.util.concurrent.Callable;

class AuthenticatePullStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with base image registry";
    private final BuildConfiguration buildConfiguration;

    AuthenticatePullStep(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    @Override
    public Authorization call() throws RegistryAuthenticationFailedException, IOException, RegistryException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            Authorization authorization = RegistryAuthenticators.forOther(this.buildConfiguration.getBaseImageServerUrl(), this.buildConfiguration.getBaseImageName()).authenticate();
            return authorization;
        }
    }
}

