/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.DockerCredentialRetriever;
import com.google.cloud.tools.jib.registry.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.NonexistentServerUrlDockerCredentialHelperException;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with %s using docker-credential-%s";
    private final BuildConfiguration buildConfiguration;

    AuthenticatePushStep(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    @Override
    @Nullable
    public Authorization call() throws NonexistentServerUrlDockerCredentialHelperException, NonexistentDockerCredentialHelperException, IOException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getTargetServerUrl(), this.buildConfiguration.getCredentialHelperName()));){
            if (this.buildConfiguration.getCredentialHelperName() == null) {
                Authorization authorization = null;
                return authorization;
            }
            DockerCredentialRetriever dockerCredentialRetriever = new DockerCredentialRetriever(this.buildConfiguration.getTargetServerUrl(), this.buildConfiguration.getCredentialHelperName());
            Authorization authorization = dockerCredentialRetriever.retrieve();
            return authorization;
        }
    }
}

