/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class BuildAndPushContainerConfigurationStep
implements Callable<ListenableFuture<BlobDescriptor>> {
    private static final String DESCRIPTION = "Building container configuration";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Authorization> pushAuthorizationFuture;
    private final ListenableFuture<List<ListenableFuture<CachedLayer>>> pullBaseImageLayerFuturesFuture;
    private final List<ListenableFuture<CachedLayer>> buildApplicationLayerFutures;
    private final List<String> entrypoint;

    BuildAndPushContainerConfigurationStep(BuildConfiguration buildConfiguration, ListeningExecutorService listeningExecutorService, ListenableFuture<Authorization> pushAuthorizationFuture, ListenableFuture<List<ListenableFuture<CachedLayer>>> pullBaseImageLayerFuturesFuture, List<ListenableFuture<CachedLayer>> buildApplicationLayerFutures, List<String> entrypoint) {
        this.buildConfiguration = buildConfiguration;
        this.listeningExecutorService = listeningExecutorService;
        this.pushAuthorizationFuture = pushAuthorizationFuture;
        this.pullBaseImageLayerFuturesFuture = pullBaseImageLayerFuturesFuture;
        this.buildApplicationLayerFutures = buildApplicationLayerFutures;
        this.entrypoint = entrypoint;
    }

    @Override
    public ListenableFuture<BlobDescriptor> call() throws ExecutionException, InterruptedException {
        ArrayList<Object> afterBaseImageLayerFuturesFutureDependencies = new ArrayList<Object>();
        afterBaseImageLayerFuturesFutureDependencies.add(this.pushAuthorizationFuture);
        afterBaseImageLayerFuturesFutureDependencies.addAll((Collection)NonBlockingFutures.get(this.pullBaseImageLayerFuturesFuture));
        afterBaseImageLayerFuturesFutureDependencies.addAll(this.buildApplicationLayerFutures);
        return Futures.whenAllSucceed(afterBaseImageLayerFuturesFutureDependencies).call(this::afterBaseImageLayerFuturesFuture, (Executor)this.listeningExecutorService);
    }

    private BlobDescriptor afterBaseImageLayerFuturesFuture() throws ExecutionException, InterruptedException, LayerPropertyNotFoundException, DuplicateLayerException, IOException, RegistryException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            RegistryClient registryClient = new RegistryClient(NonBlockingFutures.get(this.pushAuthorizationFuture), this.buildConfiguration.getTargetServerUrl(), this.buildConfiguration.getTargetImageName()).setTimer(timer);
            Image image = new Image();
            for (Future future : NonBlockingFutures.get(this.pullBaseImageLayerFuturesFuture)) {
                image.addLayer((Layer)NonBlockingFutures.get(future));
            }
            for (Future future : this.buildApplicationLayerFutures) {
                image.addLayer((Layer)NonBlockingFutures.get(future));
            }
            image.setEnvironment(this.buildConfiguration.getEnvironment());
            image.setEntrypoint(this.entrypoint);
            ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(image);
            Blob blob = imageToJsonTranslator.getContainerConfigurationBlob();
            CountingDigestOutputStream digestOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());
            blob.writeTo(digestOutputStream);
            BlobDescriptor containerConfigurationBlobDescriptor = digestOutputStream.toBlobDescriptor();
            timer.lap("Pushing container configuration " + containerConfigurationBlobDescriptor.getDigest());
            registryClient.pushBlob(containerConfigurationBlobDescriptor.getDigest(), blob);
            BlobDescriptor blobDescriptor = containerConfigurationBlobDescriptor;
            return blobDescriptor;
        }
    }
}

