/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerType;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.image.ImageLayers;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;

public class CacheReader {
    private final Cache cache;

    public CacheReader(Cache cache) {
        this.cache = cache;
    }

    public Path getLayerFile(CachedLayerType layerType, List<Path> sourceFiles) throws CacheMetadataCorruptedException {
        switch (layerType) {
            case DEPENDENCIES: 
            case RESOURCES: 
            case CLASSES: {
                CacheMetadata cacheMetadata = this.cache.getMetadata();
                ImageLayers<CachedLayerWithMetadata> cachedLayers = cacheMetadata.filterLayers().byType(layerType).bySourceFiles(sourceFiles).filter();
                FileTime newestLastModifiedTime = FileTime.from(Instant.MIN);
                Path newestLayerFile = null;
                for (CachedLayerWithMetadata cachedLayer : cachedLayers) {
                    FileTime cachedLayerLastModifiedTime = cachedLayer.getMetadata().getLastModifiedTime();
                    if (cachedLayerLastModifiedTime.compareTo(newestLastModifiedTime) <= 0) continue;
                    newestLastModifiedTime = cachedLayerLastModifiedTime;
                    newestLayerFile = cachedLayer.getContentFile();
                }
                return newestLayerFile;
            }
        }
        throw new UnsupportedOperationException("Can only find layer files for application layers");
    }
}

