/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class LayerBuilder {
    private final List<Path> sourceFiles;
    private final Path extractionPath;

    public LayerBuilder(List<Path> sourceFiles, Path extractionPath) {
        this.sourceFiles = new ArrayList<Path>(sourceFiles);
        this.extractionPath = extractionPath;
    }

    public UnwrittenLayer build() throws IOException {
        ArrayList<TarArchiveEntry> filesystemEntries = new ArrayList<TarArchiveEntry>();
        for (Path sourceFile : this.sourceFiles) {
            if (Files.isDirectory(sourceFile, new LinkOption[0])) {
                Files.walk(sourceFile, new FileVisitOption[0]).filter(path -> !path.equals(sourceFile)).forEach(path -> {
                    Path subExtractionPath = this.extractionPath.resolve(sourceFile.getParent().relativize((Path)path));
                    filesystemEntries.add(new TarArchiveEntry(path.toFile(), subExtractionPath.toString()));
                });
                continue;
            }
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(sourceFile.toFile(), this.extractionPath.resolve(sourceFile.getFileName()).toString());
            tarArchiveEntry.setModTime(0L);
            filesystemEntries.add(tarArchiveEntry);
        }
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        for (TarArchiveEntry entry : filesystemEntries) {
            tarStreamBuilder.addEntry(entry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public List<Path> getSourceFiles() {
        return Collections.unmodifiableList(this.sourceFiles);
    }
}

