/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;

public class ImageToJsonTranslator {
    private final Image image;

    public ImageToJsonTranslator(Image image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() throws LayerPropertyNotFoundException {
        ContainerConfigurationTemplate template = new ContainerConfigurationTemplate();
        for (Layer layer : this.image.getLayers()) {
            template.addLayerDiffId(layer.getDiffId());
        }
        template.setContainerEnvironment(this.image.getEnvironment());
        template.setContainerEntrypoint(this.image.getEntrypoint());
        return JsonTemplateMapper.toBlob(template);
    }

    public V22ManifestTemplate getManifestTemplate(BlobDescriptor containerConfigurationBlobDescriptor) throws LayerPropertyNotFoundException {
        V22ManifestTemplate template = new V22ManifestTemplate();
        DescriptorDigest containerConfigurationDigest = containerConfigurationBlobDescriptor.getDigest();
        long containerConfigurationSize = containerConfigurationBlobDescriptor.getSize();
        template.setContainerConfiguration(containerConfigurationSize, containerConfigurationDigest);
        for (Layer layer : this.image.getLayers()) {
            template.addLayer(layer.getBlobDescriptor().getSize(), layer.getBlobDescriptor().getDigest());
        }
        return template;
    }
}

