/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V22ManifestTemplate
extends ManifestTemplate {
    public static final String MEDIA_TYPE = "application/vnd.docker.distribution.manifest.v2+json";
    private final int schemaVersion = 2;
    private final String mediaType = "application/vnd.docker.distribution.manifest.v2+json";
    private final ContainerConfigurationObjectTemplate config = new ContainerConfigurationObjectTemplate();
    private final List<LayerObjectTemplate> layers = new ArrayList<LayerObjectTemplate>();

    @Override
    public int getSchemaVersion() {
        return 2;
    }

    public List<LayerObjectTemplate> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public void setContainerConfiguration(long size, DescriptorDigest digest) {
        this.config.size = size;
        this.config.digest = digest;
    }

    public void addLayer(long size, DescriptorDigest digest) {
        LayerObjectTemplate layerObjectTemplate = new LayerObjectTemplate();
        layerObjectTemplate.size = size;
        layerObjectTemplate.digest = digest;
        this.layers.add(layerObjectTemplate);
    }

    @VisibleForTesting
    public DescriptorDigest getContainerConfigurationDigest() {
        return this.config.digest;
    }

    @VisibleForTesting
    long getContainerConfigurationSize() {
        return this.config.size;
    }

    @VisibleForTesting
    public DescriptorDigest getLayerDigest(int index) {
        return this.layers.get(index).digest;
    }

    @VisibleForTesting
    long getLayerSize(int index) {
        return this.layers.get(index).size;
    }

    static class LayerObjectTemplate
    extends JsonTemplate {
        private final String mediaType = "application/vnd.docker.image.rootfs.diff.tar.gzip";
        private DescriptorDigest digest;
        private long size;

        LayerObjectTemplate() {
        }

        long getSize() {
            return this.size;
        }

        DescriptorDigest getDigest() {
            return this.digest;
        }
    }

    private static class ContainerConfigurationObjectTemplate
    extends JsonTemplate {
        private final String mediaType = "application/vnd.docker.container.image.v1+json";
        private DescriptorDigest digest;
        private long size;

        private ContainerConfigurationObjectTemplate() {
        }
    }
}

