/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildImageSteps;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenSourceFilesConfiguration;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends AbstractMojo {
    private static final String CACHE_DIRECTORY_NAME = "jib-cache";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="gcr.io/distroless/java", required=true)
    private String from;
    @Parameter(required=true)
    private String registry;
    @Parameter(required=true)
    private String repository;
    @Parameter(defaultValue="latest", required=true)
    private String tag;
    @Parameter
    private String credentialHelperName;
    @Parameter
    private List<String> jvmFlags;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Plugin mavenJarPlugin;
        if (this.mainClass == null && (mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin")) != null) {
            this.mainClass = this.getMainClassFromMavenJarPlugin(mavenJarPlugin);
            if (this.mainClass == null) {
                this.throwMojoExecutionExceptionWithHelpMessage(new MojoFailureException("Could not find main class specified in maven-jar-plugin"), "add a `mainClass` configuration to jib-maven-plugin");
            }
            this.getLog().info((CharSequence)("Using main class from maven-jar-plugin: " + this.mainClass));
        }
        SourceFilesConfiguration sourceFilesConfiguration = this.getSourceFilesConfiguration();
        ImageReference baseImage = this.getImageReference();
        BuildConfiguration buildConfiguration = BuildConfiguration.builder().setBuildLogger(new MavenBuildLogger(this.getLog())).setBaseImageServerUrl(baseImage.getRegistry()).setBaseImageName(baseImage.getRepository()).setBaseImageTag(baseImage.getTag()).setTargetServerUrl(this.registry).setTargetImageName(this.repository).setTargetTag(this.tag).setCredentialHelperName(this.credentialHelperName).setMainClass(this.mainClass).setJvmFlags(this.jvmFlags).setEnvironment(this.environment).build();
        Path cacheDirectory = Paths.get(this.project.getBuild().getDirectory(), CACHE_DIRECTORY_NAME);
        if (!Files.exists(cacheDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(cacheDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Could not create cache directory: " + cacheDirectory, (Exception)ex);
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Pushing image as " + this.registry + "/" + this.repository + ":" + this.tag));
        this.getLog().info((CharSequence)"");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        this.buildImage(new BuildImageSteps(buildConfiguration, sourceFilesConfiguration, cacheDirectory));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Built and pushed image as " + this.registry + "/" + this.repository + ":" + this.tag));
        this.getLog().info((CharSequence)"");
    }

    @VisibleForTesting
    void setCredentialHelperName(String credentialHelperName) {
        this.credentialHelperName = credentialHelperName;
    }

    @VisibleForTesting
    void buildImage(BuildImageSteps buildImageSteps) throws MojoExecutionException {
        try {
            buildImageSteps.run();
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            this.throwMojoExecutionExceptionWithHelpMessage(cacheMetadataCorruptedException, "run 'mvn clean' to clear the cache");
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof HttpHostConnectException) {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), "make sure your Internet is up and that the registry you are pushing to exists");
            } else if (executionException.getCause() instanceof RegistryUnauthorizedException) {
                RegistryUnauthorizedException registryUnauthorizedException = (RegistryUnauthorizedException)executionException.getCause();
                if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
                    BuildConfiguration buildConfiguration = buildImageSteps.getBuildConfiguration();
                    String targetImage = buildConfiguration.getTargetServerUrl() + "/" + buildConfiguration.getTargetImageName() + ":" + buildConfiguration.getTargetTag();
                    this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your have permission to push to " + targetImage);
                } else if (this.credentialHelperName == null) {
                    this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "set the configuration 'credentialHelperName'");
                } else {
                    this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your credential helper 'docker-credential-" + this.credentialHelperName + "' is set up correctly");
                }
            } else {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), null);
            }
        }
        catch (IOException | InterruptedException ex) {
            this.getLog().error((Throwable)ex);
            this.throwMojoExecutionExceptionWithHelpMessage(ex, null);
        }
    }

    private SourceFilesConfiguration getSourceFilesConfiguration() throws MojoExecutionException {
        try {
            MavenSourceFilesConfiguration sourceFilesConfiguration = new MavenSourceFilesConfiguration(this.project);
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Containerizing application with the following files:");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\tDependencies:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getDependenciesFiles().forEach(dependencyFile -> this.getLog().info((CharSequence)("\t\t" + dependencyFile)));
            this.getLog().info((CharSequence)"\tResources:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getResourcesFiles().forEach(resourceFile -> this.getLog().info((CharSequence)("\t\t" + resourceFile)));
            this.getLog().info((CharSequence)"\tClasses:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getClassesFiles().forEach(classesFile -> this.getLog().info((CharSequence)("\t\t" + classesFile)));
            this.getLog().info((CharSequence)"");
            return sourceFilesConfiguration;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed", (Exception)ex);
        }
    }

    @Nullable
    private String getMainClassFromMavenJarPlugin(Plugin mavenJarPlugin) {
        Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
        if (jarConfiguration == null) {
            return null;
        }
        Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
        if (archiveObject == null) {
            return null;
        }
        Xpp3Dom manifestObject = archiveObject.getChild("manifest");
        if (manifestObject == null) {
            return null;
        }
        Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
        if (mainClassObject == null) {
            return null;
        }
        return mainClassObject.getValue();
    }

    private ImageReference getImageReference() throws MojoFailureException {
        try {
            return ImageReference.parse(this.from);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoFailureException("Parameter 'from' is invalid", (Throwable)ex);
        }
    }

    private <T extends Throwable> void throwMojoExecutionExceptionWithHelpMessage(T ex, @Nullable String suggestion) throws MojoExecutionException {
        StringBuilder message = new StringBuilder("Build image failed");
        if (suggestion != null) {
            message.append(", perhaps you should ");
            message.append(suggestion);
        }
        throw new MojoExecutionException(message.toString(), ex);
    }
}

