/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegistryAuthenticator {
    private final URL authenticationUrl;

    static RegistryAuthenticator fromAuthenticationMethod(String authenticationMethod, String repository) throws RegistryAuthenticationFailedException, MalformedURLException {
        if (!authenticationMethod.matches("^Bearer .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "Bearer");
        }
        Pattern realmPattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher realmMatcher = realmPattern.matcher(authenticationMethod);
        if (!realmMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "realm");
        }
        String realm = realmMatcher.group(1);
        Pattern servicePattern = Pattern.compile("service=\"(.*?)\"");
        Matcher serviceMatcher = servicePattern.matcher(authenticationMethod);
        if (!serviceMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(authenticationMethod, "service");
        }
        String service = serviceMatcher.group(1);
        return new RegistryAuthenticator(realm, service, repository);
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String authenticationMethod, String authParam) {
        return new RegistryAuthenticationFailedException("'" + authParam + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + authenticationMethod);
    }

    RegistryAuthenticator(String realm, String service, String repository) throws MalformedURLException {
        this.authenticationUrl = new URL(realm + "?service=" + service + "&scope=repository:" + repository + ":pull");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Authorization authenticate() throws RegistryAuthenticationFailedException {
        try (Connection connection = new Connection(this.authenticationUrl);){
            Response response = connection.get(Request.builder().build());
            String responseString = Blobs.writeToString(response.getBody());
            AuthenticationResponseTemplate responseJson = JsonTemplateMapper.readJson(responseString, AuthenticationResponseTemplate.class);
            Authorization authorization = Authorizations.withBearerToken(responseJson.token);
            return authorization;
        }
        catch (IOException ex) {
            throw new RegistryAuthenticationFailedException(ex);
        }
    }

    @VisibleForTesting
    URL getAuthenticationUrl() {
        return this.authenticationUrl;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticationResponseTemplate
    extends JsonTemplate {
        private String token;

        private AuthenticationResponseTemplate() {
        }
    }
}

