/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.IOException;
import java.net.MalformedURLException;

public abstract class RegistryAuthenticators {
    public static RegistryAuthenticator forDockerHub(String repository) throws RegistryAuthenticationFailedException {
        try {
            return new RegistryAuthenticator("https://auth.docker.io/token", "registry.docker.io", repository);
        }
        catch (MalformedURLException ex) {
            throw new RegistryAuthenticationFailedException(ex);
        }
    }

    public static RegistryAuthenticator forOther(String serverUrl, String repository) throws RegistryAuthenticationFailedException, IOException, RegistryException {
        try {
            RegistryClient registryClient = new RegistryClient(null, serverUrl, repository);
            return registryClient.getRegistryAuthenticator();
        }
        catch (MalformedURLException ex) {
            throw new RegistryAuthenticationFailedException(ex);
        }
    }
}

