/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryNoResponseException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.NoHttpResponseException;

public class RegistryClient {
    private Timer parentTimer = new Timer(new BuildLogger(){

        @Override
        public void debug(CharSequence message) {
        }

        @Override
        public void info(CharSequence message) {
        }

        @Override
        public void warn(CharSequence message) {
        }

        @Override
        public void error(CharSequence message) {
        }
    }, "NULL TIMER");
    private static final String PROTOCOL = "https";
    @Nullable
    private static String userAgentSuffix;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointProperties registryEndpointProperties;

    public RegistryClient setTimer(Timer parentTimer) {
        this.parentTimer = parentTimer;
        return this;
    }

    public static void setUserAgentSuffix(@Nullable String userAgentSuffix) {
        RegistryClient.userAgentSuffix = userAgentSuffix;
    }

    @VisibleForTesting
    static String getUserAgent() {
        String version = RegistryClient.class.getPackage().getImplementationVersion();
        StringBuilder userAgentBuilder = new StringBuilder();
        userAgentBuilder.append("jib");
        if (version != null) {
            userAgentBuilder.append(" ").append(version);
        }
        if (userAgentSuffix != null) {
            userAgentBuilder.append(" ").append(userAgentSuffix);
        }
        return userAgentBuilder.toString();
    }

    public RegistryClient(@Nullable Authorization authorization, String serverUrl, String imageName) {
        this.authorization = authorization;
        this.registryEndpointProperties = new RegistryEndpointProperties(serverUrl, imageName);
    }

    public RegistryAuthenticator getRegistryAuthenticator() throws IOException, RegistryException {
        AuthenticationMethodRetriever authenticationMethodRetriever = new AuthenticationMethodRetriever(this.registryEndpointProperties);
        return this.callRegistryEndpoint(authenticationMethodRetriever);
    }

    public <T extends ManifestTemplate> T pullManifest(String imageTag, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointProperties, imageTag, manifestTemplateClass);
        return (T)((ManifestTemplate)this.callRegistryEndpoint(manifestPuller));
    }

    public ManifestTemplate pullManifest(String imageTag) throws IOException, RegistryException {
        return this.pullManifest(imageTag, ManifestTemplate.class);
    }

    public void pushManifest(V22ManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        ManifestPusher manifestPusher = new ManifestPusher(this.registryEndpointProperties, manifestTemplate, imageTag);
        this.callRegistryEndpoint(manifestPusher);
    }

    public BlobDescriptor checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Void pullBlob(DescriptorDigest blobDigest, OutputStream destinationOutputStream) throws RegistryException, IOException {
        BlobPuller blobPuller = new BlobPuller(this.registryEndpointProperties, blobDigest, destinationOutputStream);
        return this.callRegistryEndpoint(blobPuller);
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String getApiRouteBase() {
        return "https://" + this.registryEndpointProperties.getServerUrl() + "/v2/";
    }

    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return this.callRegistryEndpoint(null, registryEndpointProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T callRegistryEndpoint(@Nullable URL url, RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        if (url == null) {
            url = registryEndpointProvider.getApiRoute(this.getApiRouteBase());
        }
        try (Connection connection = new Connection(url);){
            Request request = Request.builder().setAuthorization(this.authorization).setUserAgent(RegistryClient.getUserAgent()).setAccept(registryEndpointProvider.getAccept()).setBody(registryEndpointProvider.getContent()).build();
            Response response = connection.send(registryEndpointProvider.getHttpMethod(), request);
            T t = registryEndpointProvider.handleResponse(response);
            return t;
        }
        catch (HttpResponseException ex) {
            try {
                return registryEndpointProvider.handleHttpResponseException(ex);
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 400 || httpResponseException.getStatusCode() == 404 || httpResponseException.getStatusCode() == 405) {
                    ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(httpResponseException.getContent(), ErrorResponseTemplate.class);
                    RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(registryEndpointProvider.getActionDescription(), httpResponseException);
                    Iterator<ErrorEntryTemplate> iterator = errorResponse.getErrors().iterator();
                    while (iterator.hasNext()) {
                        ErrorEntryTemplate errorEntry = iterator.next();
                        registryErrorExceptionBuilder.addReason(errorEntry);
                    }
                    throw registryErrorExceptionBuilder.build();
                }
                if (httpResponseException.getStatusCode() == 401) throw new RegistryUnauthorizedException(httpResponseException);
                if (httpResponseException.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(httpResponseException);
                }
                if (httpResponseException.getStatusCode() != 307) throw httpResponseException;
                return this.callRegistryEndpoint(new URL(httpResponseException.getHeaders().getLocation()), registryEndpointProvider);
            }
        }
        catch (NoHttpResponseException ex) {
            throw new RegistryNoResponseException(ex);
        }
        catch (SSLPeerUnverifiedException ex) {
            GenericUrl httpUrl = new GenericUrl(url);
            httpUrl.setScheme("http");
            return this.callRegistryEndpoint(httpUrl.toURL(), registryEndpointProvider);
        }
    }
}

