/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;

class RegistryErrorExceptionBuilder {
    private final Throwable cause;
    private final StringBuilder errorMessageBuilder = new StringBuilder();
    private boolean firstErrorReason = true;

    private static String getReason(String errorCodeString, String message) {
        try {
            ErrorCodes errorCode = ErrorCodes.valueOf(errorCodeString);
            switch (errorCode) {
                case MANIFEST_UNKNOWN: {
                    return message;
                }
            }
            return "other: " + message;
        }
        catch (IllegalArgumentException ex) {
            return "unknown: " + message;
        }
    }

    RegistryErrorExceptionBuilder(String method, Throwable cause) {
        this.cause = cause;
        this.errorMessageBuilder.append("Tried to ");
        this.errorMessageBuilder.append(method);
        this.errorMessageBuilder.append(" but failed because: ");
    }

    RegistryErrorExceptionBuilder(String method) {
        this(method, null);
    }

    RegistryErrorExceptionBuilder addReason(ErrorEntryTemplate errorEntry) {
        String reason = RegistryErrorExceptionBuilder.getReason(errorEntry.getCode(), errorEntry.getMessage());
        this.addReason(reason);
        return this;
    }

    RegistryErrorExceptionBuilder addReason(String reason) {
        if (!this.firstErrorReason) {
            this.errorMessageBuilder.append(", ");
        }
        this.errorMessageBuilder.append(reason);
        this.firstErrorReason = false;
        return this;
    }

    RegistryErrorException build() {
        return new RegistryErrorException(this.errorMessageBuilder.toString(), this.cause);
    }
}

