/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final List<TarArchiveEntry> entries = new ArrayList<TarArchiveEntry>();

    private static void writeEntriesAsTarArchive(List<TarArchiveEntry> entries, OutputStream tarByteStream) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(tarByteStream);){
            for (TarArchiveEntry entry : entries) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry);
                if (entry.isFile()) {
                    BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(entry.getFile()));
                    ByteStreams.copy((InputStream)contentStream, (OutputStream)tarArchiveOutputStream);
                }
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addEntry(TarArchiveEntry entry) {
        this.entries.add(entry);
    }

    public Blob toBlob() {
        return Blobs.from(outputStream -> TarStreamBuilder.writeEntriesAsTarArchive(Collections.unmodifiableList(this.entries), outputStream));
    }
}

