/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryAuthenticators;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class AuthenticatePullStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating pull from %s";
    private final BuildConfiguration buildConfiguration;
    private final ListenableFuture<Authorization> registryCredentialsFuture;

    AuthenticatePullStep(BuildConfiguration buildConfiguration, ListenableFuture<Authorization> registryCredentialsFuture) {
        this.buildConfiguration = buildConfiguration;
        this.registryCredentialsFuture = registryCredentialsFuture;
    }

    @Override
    public Authorization call() throws RegistryAuthenticationFailedException, IOException, RegistryException, ExecutionException, InterruptedException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getBaseImageRegistry()));){
            Authorization registryCredentials = NonBlockingFutures.get(this.registryCredentialsFuture);
            RegistryAuthenticator registryAuthenticator = RegistryAuthenticators.forOther(this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
            if (registryAuthenticator == null) {
                Authorization authorization = registryCredentials;
                return authorization;
            }
            Authorization authorization = registryAuthenticator.setAuthorization(registryCredentials).authenticatePull();
            return authorization;
        }
    }
}

