/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryAuthenticators;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with push to %s";
    private final BuildConfiguration buildConfiguration;
    private final ListenableFuture<Authorization> registryCredentialsFuture;

    AuthenticatePushStep(BuildConfiguration buildConfiguration, ListenableFuture<Authorization> registryCredentialsFuture) {
        this.buildConfiguration = buildConfiguration;
        this.registryCredentialsFuture = registryCredentialsFuture;
    }

    @Override
    @Nullable
    public Authorization call() throws ExecutionException, InterruptedException, RegistryAuthenticationFailedException, IOException, RegistryException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getTargetRegistry()));){
            Authorization registryCredentials = NonBlockingFutures.get(this.registryCredentialsFuture);
            RegistryAuthenticator registryAuthenticator = RegistryAuthenticators.forOther(this.buildConfiguration.getTargetRegistry(), this.buildConfiguration.getTargetRepository());
            if (registryAuthenticator == null) {
                Authorization authorization = registryCredentials;
                return authorization;
            }
            Authorization authorization = registryAuthenticator.setAuthorization(NonBlockingFutures.get(this.registryCredentialsFuture)).authenticatePush();
            return authorization;
        }
    }
}

