/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.builder.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class PullAndCacheBaseImageLayersStep
implements Callable<List<ListenableFuture<CachedLayer>>> {
    private static final String DESCRIPTION = "Setting up base image caching";
    private final BuildConfiguration buildConfiguration;
    private final Cache cache;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Authorization> pullAuthorizationFuture;
    private final ListenableFuture<Image> baseImageFuture;

    PullAndCacheBaseImageLayersStep(BuildConfiguration buildConfiguration, Cache cache, ListeningExecutorService listeningExecutorService, ListenableFuture<Authorization> pullAuthorizationFuture, ListenableFuture<Image> baseImageFuture) {
        this.buildConfiguration = buildConfiguration;
        this.cache = cache;
        this.listeningExecutorService = listeningExecutorService;
        this.pullAuthorizationFuture = pullAuthorizationFuture;
        this.baseImageFuture = baseImageFuture;
    }

    @Override
    public List<ListenableFuture<CachedLayer>> call() throws ExecutionException, InterruptedException, LayerPropertyNotFoundException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ArrayList<ListenableFuture> pullAndCacheBaseImageLayerFutures = new ArrayList<ListenableFuture>();
            for (Layer layer : NonBlockingFutures.get(this.baseImageFuture).getLayers()) {
                pullAndCacheBaseImageLayerFutures.add(Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.pullAuthorizationFuture}).call((Callable)new PullAndCacheBaseImageLayerStep(this.buildConfiguration, this.cache, layer.getBlobDescriptor().getDigest(), (Future<Authorization>)this.pullAuthorizationFuture), (Executor)this.listeningExecutorService));
            }
            ArrayList<ListenableFuture> arrayList = pullAndCacheBaseImageLayerFutures;
            return arrayList;
        }
    }
}

