/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class CacheChecker {
    private final Cache cache;

    private static FileTime getLastModifiedTime(Path path) throws IOException {
        FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
        if (Files.isReadable(path)) {
            try {
                Optional<FileTime> maxLastModifiedTime = Files.walk(path, new FileVisitOption[0]).map(subFilePath -> {
                    try {
                        return Files.getLastModifiedTime(subFilePath, new LinkOption[0]);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }).max(FileTime::compareTo);
                if (!maxLastModifiedTime.isPresent()) {
                    throw new IllegalStateException("Could not get last modified time for all files in directory '" + path + "'");
                }
                if (maxLastModifiedTime.get().compareTo(lastModifiedTime) > 0) {
                    lastModifiedTime = maxLastModifiedTime.get();
                }
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
        return lastModifiedTime;
    }

    public CacheChecker(Cache cache) {
        this.cache = cache;
    }

    public CachedLayer getLayer(DescriptorDigest layerDigest) throws LayerPropertyNotFoundException {
        return this.cache.getMetadata().getLayers().get(layerDigest);
    }

    public CachedLayer getUpToDateLayerBySourceFiles(List<Path> sourceFiles) throws IOException, CacheMetadataCorruptedException {
        ImageLayers<CachedLayerWithMetadata> cachedLayersWithSourceFiles = this.cache.getMetadata().filterLayers().bySourceFiles(sourceFiles).filter();
        if (cachedLayersWithSourceFiles.isEmpty()) {
            return null;
        }
        FileTime sourceFilesLastModifiedTime = FileTime.from(Instant.MIN);
        for (Path path : sourceFiles) {
            FileTime lastModifiedTime = CacheChecker.getLastModifiedTime(path);
            if (lastModifiedTime.compareTo(sourceFilesLastModifiedTime) <= 0) continue;
            sourceFilesLastModifiedTime = lastModifiedTime;
        }
        for (CachedLayerWithMetadata cachedLayer : cachedLayersWithSourceFiles) {
            if (sourceFilesLastModifiedTime.compareTo(cachedLayer.getMetadata().getLastModifiedTime()) > 0) continue;
            return cachedLayer;
        }
        return null;
    }

    @Deprecated
    public boolean areSourceFilesModified(List<Path> sourceFiles) throws IOException, CacheMetadataCorruptedException {
        ImageLayers<CachedLayerWithMetadata> cachedLayersWithSourceFiles = this.cache.getMetadata().filterLayers().bySourceFiles(sourceFiles).filter();
        if (cachedLayersWithSourceFiles.isEmpty()) {
            return true;
        }
        FileTime sourceFilesLastModifiedTime = FileTime.from(Instant.MIN);
        for (Path path : sourceFiles) {
            FileTime lastModifiedTime = CacheChecker.getLastModifiedTime(path);
            if (lastModifiedTime.compareTo(sourceFilesLastModifiedTime) <= 0) continue;
            sourceFilesLastModifiedTime = lastModifiedTime;
        }
        for (CachedLayerWithMetadata cachedLayer : cachedLayersWithSourceFiles) {
            if (sourceFilesLastModifiedTime.compareTo(cachedLayer.getMetadata().getLastModifiedTime()) > 0) continue;
            return false;
        }
        return true;
    }
}

