/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerType;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.LayerBuilder;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CacheWriter {
    private final Cache cache;

    public CacheWriter(Cache cache) {
        this.cache = cache;
    }

    public CachedLayer writeLayer(LayerBuilder layerBuilder, CachedLayerType layerType) throws IOException, LayerPropertyNotFoundException, DuplicateLayerException {
        UnwrittenLayer unwrittenLayer = layerBuilder.build();
        Path tempLayerFile = Files.createTempFile(this.cache.getCacheDirectory(), null, null, new FileAttribute[0]);
        tempLayerFile.toFile().deleteOnExit();
        try (CountingDigestOutputStream compressedDigestOutputStream = new CountingDigestOutputStream(new BufferedOutputStream(Files.newOutputStream(tempLayerFile, new OpenOption[0])));){
            GZIPOutputStream compressorStream = new GZIPOutputStream(compressedDigestOutputStream);
            DescriptorDigest diffId = unwrittenLayer.getBlob().writeTo(compressorStream).getDigest();
            compressorStream.close();
            BlobDescriptor compressedBlobDescriptor = compressedDigestOutputStream.toBlobDescriptor();
            Path layerFile = this.getLayerFile(compressedBlobDescriptor.getDigest());
            if (!Files.exists(layerFile, new LinkOption[0])) {
                Files.move(tempLayerFile, layerFile, new CopyOption[0]);
            }
            CachedLayer cachedLayer = new CachedLayer(layerFile, compressedBlobDescriptor, diffId);
            LayerMetadata layerMetadata = LayerMetadata.from(layerBuilder.getSourceFiles(), FileTime.from(Instant.now()));
            this.cache.addLayerToMetadata(layerType, cachedLayer, layerMetadata);
            CachedLayer cachedLayer2 = cachedLayer;
            return cachedLayer2;
        }
    }

    public CountingOutputStream getLayerOutputStream(DescriptorDigest layerDigest) throws IOException {
        Path layerFile = this.getLayerFile(layerDigest);
        return new CountingOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(layerFile, new OpenOption[0])));
    }

    public CachedLayer getCachedLayer(DescriptorDigest layerDigest, CountingOutputStream countingOutputStream) throws IOException, LayerPropertyNotFoundException, DuplicateLayerException {
        Path layerFile = this.getLayerFile(layerDigest);
        countingOutputStream.close();
        CachedLayer cachedLayer = new CachedLayer(layerFile, new BlobDescriptor(countingOutputStream.getCount(), layerDigest), this.getDiffId(layerFile));
        this.cache.addLayerToMetadata(CachedLayerType.BASE, cachedLayer, null);
        return cachedLayer;
    }

    private Path getLayerFile(DescriptorDigest compressedDigest) {
        return CacheFiles.getLayerFile(this.cache.getCacheDirectory(), compressedDigest);
    }

    private DescriptorDigest getDiffId(Path layerFile) throws IOException {
        CountingDigestOutputStream diffIdCaptureOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());
        try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(layerFile, new OpenOption[0]));
             GZIPInputStream decompressorStream = new GZIPInputStream(fileInputStream);){
            ByteStreams.copy((InputStream)decompressorStream, (OutputStream)diffIdCaptureOutputStream);
        }
        return diffIdCaptureOutputStream.toBlobDescriptor().getDigest();
    }
}

