/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;

public class Caches {
    private final Cache baseCache;
    private final Cache applicationCache;

    public static Initializer initializer() {
        return new Initializer();
    }

    private Caches(Path baseCacheDirectory, Path applicationCacheDirectory) throws CacheMetadataCorruptedException, NotDirectoryException {
        this.baseCache = Cache.init(baseCacheDirectory);
        this.applicationCache = Cache.init(applicationCacheDirectory);
    }

    Cache getBaseCache() {
        return this.baseCache;
    }

    Cache getApplicationCache() {
        return this.applicationCache;
    }

    public static class Initializer {
        private Path baseCacheDirectory;
        private Path applicationCacheDirectory;

        private Initializer() {
        }

        public Initializer setBaseCacheDirectory(Path baseCacheDirectory) {
            this.baseCacheDirectory = baseCacheDirectory;
            return this;
        }

        public Initializer setApplicationCacheDirectory(Path applicationCacheDirectory) {
            this.applicationCacheDirectory = applicationCacheDirectory;
            return this;
        }

        public Caches init() throws CacheMetadataCorruptedException, NotDirectoryException {
            if (this.baseCacheDirectory == null || this.applicationCacheDirectory == null) {
                throw new IllegalStateException("Must initialize cache with both base image layer cache directory and application image layer cache directory");
            }
            return new Caches(this.baseCacheDirectory, this.applicationCacheDirectory);
        }
    }
}

