/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildImageSteps;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.maven.MavenBuildLogger;
import com.google.cloud.tools.jib.maven.MavenSourceFilesConfiguration;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildImageMojo
extends AbstractMojo {
    private static final String CACHE_DIRECTORY_NAME = "jib-cache";
    private static final String USER_AGENT_SUFFIX = "jib-maven-plugin";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="gcr.io/distroless/java", required=true)
    private String from;
    @Parameter(required=true)
    private String registry;
    @Parameter(required=true)
    private String repository;
    @Parameter(defaultValue="latest", required=true)
    private String tag;
    @Parameter
    private List<String> credHelpers;
    @Parameter
    private List<String> jvmFlags;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private String mainClass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Authorization targetRegistryCredentials;
        Plugin mavenJarPlugin;
        this.validateParameters();
        if (this.mainClass == null && (mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin")) != null) {
            this.mainClass = this.getMainClassFromMavenJarPlugin(mavenJarPlugin);
            if (this.mainClass == null) {
                this.throwMojoExecutionExceptionWithHelpMessage(new MojoFailureException("Could not find main class specified in maven-jar-plugin"), "add a `mainClass` configuration to jib-maven-plugin");
            }
            this.getLog().info((CharSequence)("Using main class from maven-jar-plugin: " + this.mainClass));
        }
        SourceFilesConfiguration sourceFilesConfiguration = this.getSourceFilesConfiguration();
        ImageReference baseImage = this.getBaseImageReference();
        this.session.getSettings().getServer(baseImage.getRegistry());
        HashMap<String, Authorization> registryCredentials = new HashMap<String, Authorization>(2);
        Authorization baseImageRegistryCredentials = this.getRegistryCredentialsFromSettings(baseImage.getRegistry());
        if (baseImageRegistryCredentials != null) {
            registryCredentials.put(baseImage.getRegistry(), baseImageRegistryCredentials);
        }
        if ((targetRegistryCredentials = this.getRegistryCredentialsFromSettings(this.registry)) != null) {
            registryCredentials.put(this.registry, targetRegistryCredentials);
        }
        RegistryCredentials mavenSettingsCredentials = RegistryCredentials.from("Maven settings", registryCredentials);
        BuildConfiguration buildConfiguration = BuildConfiguration.builder().setBuildLogger(new MavenBuildLogger(this.getLog())).setBaseImageRegistry(baseImage.getRegistry()).setBaseImageRepository(baseImage.getRepository()).setBaseImageTag(baseImage.getTag()).setTargetRegistry(this.registry).setTargetRepository(this.repository).setTargetTag(this.tag).setCredentialHelperNames(this.credHelpers).setKnownRegistryCredentials(mavenSettingsCredentials).setMainClass(this.mainClass).setJvmFlags(this.jvmFlags).setEnvironment(this.environment).build();
        Path cacheDirectory = Paths.get(this.project.getBuild().getDirectory(), CACHE_DIRECTORY_NAME);
        if (!Files.exists(cacheDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(cacheDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Could not create cache directory: " + cacheDirectory, (Exception)ex);
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Pushing image as " + this.registry + "/" + this.repository + ":" + this.tag));
        this.getLog().info((CharSequence)"");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        RegistryClient.setUserAgentSuffix(USER_AGENT_SUFFIX);
        this.buildImage(new BuildImageSteps(buildConfiguration, sourceFilesConfiguration, cacheDirectory));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Built and pushed image as " + this.registry + "/" + this.repository + ":" + this.tag));
        this.getLog().info((CharSequence)"");
    }

    @VisibleForTesting
    void buildImage(BuildImageSteps buildImageSteps) throws MojoExecutionException {
        try {
            buildImageSteps.run();
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            this.throwMojoExecutionExceptionWithHelpMessage(cacheMetadataCorruptedException, "run 'mvn clean' to clear the cache");
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = buildImageSteps.getBuildConfiguration();
            if (executionException.getCause() instanceof HttpHostConnectException) {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), "make sure your Internet is up and that the registry you are pushing to exists");
            } else if (executionException.getCause() instanceof RegistryUnauthorizedException) {
                this.handleRegistryUnauthorizedException((RegistryUnauthorizedException)executionException.getCause(), buildConfiguration);
            } else if (executionException.getCause() instanceof RegistryAuthenticationFailedException && executionException.getCause().getCause() instanceof HttpResponseException) {
                this.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetRegistry(), buildConfiguration.getTargetRepository(), (HttpResponseException)executionException.getCause().getCause()), buildConfiguration);
            } else {
                this.throwMojoExecutionExceptionWithHelpMessage(executionException.getCause(), null);
            }
        }
        catch (IOException | InterruptedException ex) {
            this.getLog().error((Throwable)ex);
            this.throwMojoExecutionExceptionWithHelpMessage(ex, null);
        }
    }

    @Nullable
    private Authorization getRegistryCredentialsFromSettings(String registry) {
        Server registryServerSettings = this.session.getSettings().getServer(registry);
        if (registryServerSettings == null) {
            return null;
        }
        return Authorizations.withBasicCredentials(registryServerSettings.getUsername(), registryServerSettings.getPassword());
    }

    private void validateParameters() throws MojoFailureException {
        if (!ImageReference.isValidRegistry(this.registry)) {
            this.getLog().error((CharSequence)"Invalid format for 'registry'");
        }
        if (!ImageReference.isValidRepository(this.repository)) {
            this.getLog().error((CharSequence)"Invalid format for 'repository'");
        }
        if (!ImageReference.isValidTag(this.tag)) {
            this.getLog().error((CharSequence)"Invalid format for 'tag'");
        }
        if (this.tag.indexOf(47) >= 0) {
            this.getLog().error((CharSequence)"'tag' cannot contain backslashes");
            throw new MojoFailureException("Invalid configuration parameters");
        }
    }

    private SourceFilesConfiguration getSourceFilesConfiguration() throws MojoExecutionException {
        try {
            MavenSourceFilesConfiguration sourceFilesConfiguration = new MavenSourceFilesConfiguration(this.project);
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Containerizing application with the following files:");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\tDependencies:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getDependenciesFiles().forEach(dependencyFile -> this.getLog().info((CharSequence)("\t\t" + dependencyFile)));
            this.getLog().info((CharSequence)"\tResources:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getResourcesFiles().forEach(resourceFile -> this.getLog().info((CharSequence)("\t\t" + resourceFile)));
            this.getLog().info((CharSequence)"\tClasses:");
            this.getLog().info((CharSequence)"");
            sourceFilesConfiguration.getClassesFiles().forEach(classesFile -> this.getLog().info((CharSequence)("\t\t" + classesFile)));
            this.getLog().info((CharSequence)"");
            return sourceFilesConfiguration;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Obtaining project build output files failed", (Exception)ex);
        }
    }

    @Nullable
    private String getMainClassFromMavenJarPlugin(Plugin mavenJarPlugin) {
        Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
        if (jarConfiguration == null) {
            return null;
        }
        Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
        if (archiveObject == null) {
            return null;
        }
        Xpp3Dom manifestObject = archiveObject.getChild("manifest");
        if (manifestObject == null) {
            return null;
        }
        Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
        if (mainClassObject == null) {
            return null;
        }
        return mainClassObject.getValue();
    }

    private ImageReference getBaseImageReference() throws MojoFailureException {
        try {
            return ImageReference.parse(this.from);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoFailureException("Parameter 'from' is invalid", (Throwable)ex);
        }
    }

    private void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration) throws MojoExecutionException {
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your have permissions for " + registryUnauthorizedException.getImageReference());
        } else if (!(buildConfiguration.getCredentialHelperNames() != null && !buildConfiguration.getCredentialHelperNames().isEmpty() || buildConfiguration.getKnownRegistryCredentials() != null && buildConfiguration.getKnownRegistryCredentials().has(registryUnauthorizedException.getRegistry()))) {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "set a credential helper name with the configuration 'credHelpers' or set credentials for '" + registryUnauthorizedException.getRegistry() + "' in your Maven settings");
        } else {
            this.throwMojoExecutionExceptionWithHelpMessage(registryUnauthorizedException, "make sure your credentials for '" + registryUnauthorizedException.getRegistry() + "' are set up correctly");
        }
    }

    private <T extends Throwable> void throwMojoExecutionExceptionWithHelpMessage(T ex, @Nullable String suggestion) throws MojoExecutionException {
        StringBuilder message = new StringBuilder("Build image failed");
        if (suggestion != null) {
            message.append(", perhaps you should ");
            message.append(suggestion);
        }
        throw new MojoExecutionException(message.toString(), ex);
    }
}

