/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

class MavenSourceFilesConfiguration
implements SourceFilesConfiguration {
    private static String DEPENDENCIES_PATH_ON_IMAGE = "/app/libs/";
    private static String RESOURCES_PATH_ON_IMAGE = "/app/resources/";
    private static String CLASSES_PATH_ON_IMAGE = "/app/classes/";
    private final List<Path> dependenciesFiles = new ArrayList<Path>();
    private final List<Path> resourcesFiles = new ArrayList<Path>();
    private final List<Path> classesFiles = new ArrayList<Path>();

    private static Path replaceClassExtensionWithJava(Path path) {
        if (FileSystems.getDefault().getPathMatcher("glob:**.class").matches(path)) {
            return path.resolveSibling(path.getFileName().toString().replaceAll("(.*?)\\.class", "$1.java"));
        }
        return path;
    }

    MavenSourceFilesConfiguration(MavenProject project) throws IOException {
        Path classesSourceDir = Paths.get(project.getBuild().getSourceDirectory(), new String[0]);
        Path classesOutputDir = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        for (Artifact artifact : project.getArtifacts()) {
            this.dependenciesFiles.add(artifact.getFile().toPath());
        }
        Files.list(classesOutputDir).forEach(classesOutputDirFile -> {
            Path classesSourceDirFile = MavenSourceFilesConfiguration.replaceClassExtensionWithJava(classesOutputDirFile);
            Path correspondingSourceDirFile = classesSourceDir.resolve(classesOutputDir.relativize(classesSourceDirFile));
            if (Files.exists(correspondingSourceDirFile, new LinkOption[0])) {
                this.classesFiles.add((Path)classesOutputDirFile);
            } else {
                this.resourcesFiles.add((Path)classesOutputDirFile);
            }
        });
        Collections.sort(this.dependenciesFiles);
        Collections.sort(this.resourcesFiles);
        Collections.sort(this.classesFiles);
    }

    @Override
    public List<Path> getDependenciesFiles() {
        return this.dependenciesFiles;
    }

    @Override
    public List<Path> getResourcesFiles() {
        return this.resourcesFiles;
    }

    @Override
    public List<Path> getClassesFiles() {
        return this.classesFiles;
    }

    @Override
    public String getDependenciesPathOnImage() {
        return DEPENDENCIES_PATH_ON_IMAGE;
    }

    @Override
    public String getResourcesPathOnImage() {
        return RESOURCES_PATH_ON_IMAGE;
    }

    @Override
    public String getClassesPathOnImage() {
        return CLASSES_PATH_ON_IMAGE;
    }
}

