/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.NonexistentServerUrlDockerCredentialHelperException;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class DockerCredentialRetriever {
    private final String serverUrl;
    private final String credentialHelperSuffix;

    public DockerCredentialRetriever(String serverUrl, String credentialHelperSuffix) {
        this.serverUrl = serverUrl;
        this.credentialHelperSuffix = credentialHelperSuffix;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Authorization retrieve() throws IOException, NonexistentServerUrlDockerCredentialHelperException, NonexistentDockerCredentialHelperException {
        try {
            String credentialHelper = "docker-credential-" + this.credentialHelperSuffix;
            String[] credentialHelperCommand = new String[]{credentialHelper, "get"};
            Process process = new ProcessBuilder(credentialHelperCommand).start();
            process.getOutputStream().write(this.serverUrl.getBytes(StandardCharsets.UTF_8));
            process.getOutputStream().close();
            Throwable throwable = null;
            try (InputStreamReader processStdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                String output = CharStreams.toString((Readable)processStdoutReader);
                if (output.contains("credentials not found in native keychain")) {
                    throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, output);
                }
                if (output.isEmpty()) {
                    InputStreamReader processStderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                    Throwable throwable2 = null;
                    try {
                        try {
                            String errorOutput = CharStreams.toString((Readable)processStderrReader);
                            throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, errorOutput);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (processStderrReader != null) {
                            if (throwable2 != null) {
                                try {
                                    processStderrReader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                processStderrReader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                try {
                    DockerCredentialsTemplate dockerCredentials = JsonTemplateMapper.readJson(output, DockerCredentialsTemplate.class);
                    Authorization authorization = Authorizations.withBasicCredentials(dockerCredentials.Username, dockerCredentials.Secret);
                    return authorization;
                }
                catch (JsonMappingException ex) {
                    try {
                        throw new NonexistentServerUrlDockerCredentialHelperException(credentialHelper, this.serverUrl, output);
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
            }
        }
        catch (IOException ex) {
            if (ex.getMessage().contains("No such file or directory")) {
                throw new NonexistentDockerCredentialHelperException(this.credentialHelperSuffix, ex);
            }
            throw ex;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class DockerCredentialsTemplate
    extends JsonTemplate {
        private String Username;
        private String Secret;

        private DockerCredentialsTemplate() {
        }
    }
}

