/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class BuildConfiguration {
    private final BuildLogger buildLogger;
    private final Map<Fields, Object> values;

    public static Builder builder() {
        return new Builder();
    }

    private BuildConfiguration(BuildLogger buildLogger, Map<Fields, Object> values) {
        this.buildLogger = buildLogger;
        this.values = values;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public String getBaseImageRegistry() {
        return (String)this.getFieldValue(Fields.BASE_IMAGE_REGISTRY);
    }

    public String getBaseImageRepository() {
        return (String)this.getFieldValue(Fields.BASE_IMAGE_REPOSITORY);
    }

    public String getBaseImageTag() {
        return (String)this.getFieldValue(Fields.BASE_IMAGE_TAG);
    }

    public String getTargetRegistry() {
        return (String)this.getFieldValue(Fields.TARGET_REGISTRY);
    }

    public String getTargetRepository() {
        return (String)this.getFieldValue(Fields.TARGET_REPOSITORY);
    }

    public String getTargetTag() {
        return (String)this.getFieldValue(Fields.TARGET_TAG);
    }

    public RegistryCredentials getKnownRegistryCredentials() {
        return (RegistryCredentials)this.getFieldValue(Fields.KNOWN_REGISTRY_CREDENTIALS);
    }

    public List<String> getCredentialHelperNames() {
        return (List)this.getFieldValue(Fields.CREDENTIAL_HELPER_NAMES);
    }

    public boolean getEnableReproducibleBuilds() {
        return (Boolean)this.getFieldValue(Fields.ENABLE_REPRODUCIBLE_BUILDS);
    }

    public String getMainClass() {
        return (String)this.getFieldValue(Fields.MAIN_CLASS);
    }

    public List<String> getJvmFlags() {
        return Collections.unmodifiableList((List)this.getFieldValue(Fields.JVM_FLAGS));
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)this.getFieldValue(Fields.ENVIRONMENT));
    }

    private <T> T getFieldValue(Fields field) {
        return (T)this.values.get((Object)field);
    }

    public static class Builder {
        @VisibleForTesting
        static final Map<Fields, String> FIELD_DESCRIPTIONS = new EnumMap<Fields, String>(Fields.class){
            {
                this.put(Fields.BASE_IMAGE_REGISTRY, "base image registry server URL");
                this.put(Fields.BASE_IMAGE_REPOSITORY, "base image name");
                this.put(Fields.BASE_IMAGE_TAG, "base image tag");
                this.put(Fields.TARGET_REGISTRY, "target registry server URL");
                this.put(Fields.TARGET_REPOSITORY, "target image name");
                this.put(Fields.TARGET_TAG, "target image tag");
                this.put(Fields.CREDENTIAL_HELPER_NAMES, "credential helper names");
                this.put(Fields.ENABLE_REPRODUCIBLE_BUILDS, "enable reproducible layer builds");
                this.put(Fields.MAIN_CLASS, "main class");
                this.put(Fields.JVM_FLAGS, "JVM flags");
                this.put(Fields.ENVIRONMENT, "environment variables");
            }
        };
        private static final String MISSING_FIELD_MESSAGE_SUFFIX = " required but not set in build configuration";
        private BuildLogger buildLogger;
        private Map<Fields, Object> values = new EnumMap<Fields, Object>(Fields.class);

        private Builder() {
            this.values.put(Fields.CREDENTIAL_HELPER_NAMES, Collections.emptyList());
            this.values.put(Fields.KNOWN_REGISTRY_CREDENTIALS, RegistryCredentials.none());
            this.values.put(Fields.JVM_FLAGS, Collections.emptyList());
            this.values.put(Fields.ENVIRONMENT, Collections.emptyMap());
            this.values.put(Fields.ENABLE_REPRODUCIBLE_BUILDS, false);
        }

        public Builder setBuildLogger(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
            return this;
        }

        public Builder setBaseImageRegistry(String baseImageServerUrl) {
            this.values.put(Fields.BASE_IMAGE_REGISTRY, baseImageServerUrl);
            return this;
        }

        public Builder setBaseImageRepository(String baseImageName) {
            this.values.put(Fields.BASE_IMAGE_REPOSITORY, baseImageName);
            return this;
        }

        public Builder setBaseImageTag(String baseImageTag) {
            this.values.put(Fields.BASE_IMAGE_TAG, baseImageTag);
            return this;
        }

        public Builder setTargetRegistry(String targetServerUrl) {
            this.values.put(Fields.TARGET_REGISTRY, targetServerUrl);
            return this;
        }

        public Builder setTargetRepository(String targetImageName) {
            this.values.put(Fields.TARGET_REPOSITORY, targetImageName);
            return this;
        }

        public Builder setTargetTag(String targetTag) {
            this.values.put(Fields.TARGET_TAG, targetTag);
            return this;
        }

        public Builder setCredentialHelperNames(List<String> credentialHelperNames) {
            if (credentialHelperNames != null) {
                this.values.put(Fields.CREDENTIAL_HELPER_NAMES, credentialHelperNames);
            }
            return this;
        }

        public Builder setKnownRegistryCredentials(RegistryCredentials knownRegistryCredentials) {
            if (knownRegistryCredentials != null) {
                this.values.put(Fields.KNOWN_REGISTRY_CREDENTIALS, knownRegistryCredentials);
            }
            return this;
        }

        public Builder setEnableReproducibleBuilds(boolean enable) {
            this.values.put(Fields.ENABLE_REPRODUCIBLE_BUILDS, enable);
            return this;
        }

        public Builder setMainClass(String mainClass) {
            this.values.put(Fields.MAIN_CLASS, mainClass);
            return this;
        }

        public Builder setJvmFlags(List<String> jvmFlags) {
            if (jvmFlags != null) {
                this.values.put(Fields.JVM_FLAGS, jvmFlags);
            }
            return this;
        }

        public Builder setEnvironment(Map<String, String> environment) {
            if (environment != null) {
                this.values.put(Fields.ENVIRONMENT, environment);
            }
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> descriptions = new ArrayList<String>();
            for (Fields field : Fields.values()) {
                if (!field.isRequired() || this.values.containsKey((Object)field) && this.values.get((Object)field) != null) continue;
                descriptions.add(FIELD_DESCRIPTIONS.get((Object)field));
            }
            switch (descriptions.size()) {
                case 0: {
                    this.values = Collections.unmodifiableMap(this.values);
                    return new BuildConfiguration(this.buildLogger, this.values);
                }
                case 1: {
                    throw new IllegalStateException((String)descriptions.get(0) + MISSING_FIELD_MESSAGE_SUFFIX);
                }
                case 2: {
                    throw new IllegalStateException((String)descriptions.get(0) + " and " + (String)descriptions.get(1) + MISSING_FIELD_MESSAGE_SUFFIX);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int descriptionsIndex = 0; descriptionsIndex < descriptions.size(); ++descriptionsIndex) {
                if (descriptionsIndex == descriptions.size() - 1) {
                    stringBuilder.append(", and ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)descriptions.get(descriptionsIndex));
            }
            throw new IllegalStateException(stringBuilder.append(MISSING_FIELD_MESSAGE_SUFFIX).toString());
        }
    }

    @VisibleForTesting
    static enum Fields {
        BASE_IMAGE_REGISTRY(true),
        BASE_IMAGE_REPOSITORY(true),
        BASE_IMAGE_TAG(true),
        TARGET_REGISTRY(true),
        TARGET_REPOSITORY(true),
        TARGET_TAG(true),
        CREDENTIAL_HELPER_NAMES(false),
        KNOWN_REGISTRY_CREDENTIALS(false),
        ENABLE_REPRODUCIBLE_BUILDS(false),
        MAIN_CLASS(true),
        JVM_FLAGS(false),
        ENVIRONMENT(false);

        private final boolean required;

        private Fields(boolean required) {
            this.required = required;
        }

        @VisibleForTesting
        boolean isRequired() {
            return this.required;
        }
    }
}

