/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V21ManifestTemplate
extends ManifestTemplate {
    public static final String MEDIA_TYPE = "application/vnd.docker.distribution.manifest.v1+json";
    private final int schemaVersion = 1;
    private final List<LayerObjectTemplate> fsLayers = new ArrayList<LayerObjectTemplate>();
    private final List<V1CompatibilityTemplate> history = new ArrayList<V1CompatibilityTemplate>();

    public List<DescriptorDigest> getLayerDigests() {
        ArrayList<DescriptorDigest> layerDigests = new ArrayList<DescriptorDigest>();
        for (LayerObjectTemplate layerObjectTemplate : this.fsLayers) {
            layerDigests.add(layerObjectTemplate.blobSum);
        }
        return layerDigests;
    }

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public List<LayerObjectTemplate> getFsLayers() {
        return Collections.unmodifiableList(this.fsLayers);
    }

    @VisibleForTesting
    DescriptorDigest getLayerDigest(int index) {
        return this.fsLayers.get(index).blobSum;
    }

    @VisibleForTesting
    String getV1Compatibility(int index) {
        return this.history.get(index).v1Compatibility;
    }

    private static class V1CompatibilityTemplate
    extends JsonTemplate {
        private String v1Compatibility;

        private V1CompatibilityTemplate() {
        }
    }

    static class LayerObjectTemplate
    extends JsonTemplate {
        private DescriptorDigest blobSum;

        LayerObjectTemplate() {
        }

        DescriptorDigest getDigest() {
            return this.blobSum;
        }
    }
}

