/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class JsonTemplateMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends JsonTemplate> T readJsonFromFile(Path jsonFile, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(Files.newInputStream(jsonFile, new OpenOption[0]), templateClass));
    }

    public static <T extends JsonTemplate> T readJson(String jsonString, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonString, templateClass));
    }

    public static Blob toBlob(JsonTemplate template) {
        return Blobs.from(outputStream -> objectMapper.writeValue(outputStream, (Object)template));
    }

    private JsonTemplateMapper() {
    }
}

