/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class ManifestPuller<T extends ManifestTemplate>
implements RegistryEndpointProvider<T> {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final String imageTag;
    private final Class<T> manifestTemplateClass;

    ManifestPuller(RegistryEndpointProperties registryEndpointProperties, String imageTag, Class<T> manifestTemplateClass) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.imageTag = imageTag;
        this.manifestTemplateClass = manifestTemplateClass;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        if (this.manifestTemplateClass.equals(V21ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v1+json");
        }
        if (this.manifestTemplateClass.equals(V22ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v2+json");
        }
        return Arrays.asList("application/vnd.docker.distribution.manifest.v2+json", "application/vnd.docker.distribution.manifest.v1+json");
    }

    @Override
    public T handleResponse(Response response) throws IOException, UnknownManifestFormatException {
        return this.getManifestTemplateFromJson(Blobs.writeToString(response.getBody()));
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull image manifest for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + ":" + this.imageTag;
    }

    private T getManifestTemplateFromJson(String jsonString) throws IOException, UnknownManifestFormatException {
        ObjectNode node = (ObjectNode)new ObjectMapper().readValue(jsonString, ObjectNode.class);
        if (!node.has("schemaVersion")) {
            throw new UnknownManifestFormatException("Cannot find field 'schemaVersion' in manifest");
        }
        if (!this.manifestTemplateClass.equals(ManifestTemplate.class)) {
            return (T)((ManifestTemplate)JsonTemplateMapper.readJson(jsonString, this.manifestTemplateClass));
        }
        int schemaVersion = node.get("schemaVersion").asInt(-1);
        if (schemaVersion == -1) {
            throw new UnknownManifestFormatException("`schemaVersion` field is not an integer");
        }
        if (schemaVersion == 1) {
            return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V21ManifestTemplate.class)));
        }
        if (schemaVersion == 2) {
            return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(jsonString, V22ManifestTemplate.class)));
        }
        throw new UnknownManifestFormatException("Unknown schemaVersion: " + schemaVersion + " - only 1 and 2 are supported");
    }
}

