/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

class ManifestPusher
implements RegistryEndpointProvider<Void> {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final V22ManifestTemplate manifestTemplate;
    private final String imageTag;

    ManifestPusher(RegistryEndpointProperties registryEndpointProperties, V22ManifestTemplate manifestTemplate, String imageTag) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.manifestTemplate = manifestTemplate;
        this.imageTag = imageTag;
    }

    @Override
    public BlobHttpContent getContent() {
        return new BlobHttpContent(JsonTemplateMapper.toBlob(this.manifestTemplate), "application/vnd.docker.distribution.manifest.v2+json");
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public Void handleResponse(Response response) {
        return null;
    }

    @Override
    public URL getApiRoute(String apiRouteBase) throws MalformedURLException {
        return new URL(apiRouteBase + this.registryEndpointProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "PUT";
    }

    @Override
    public String getActionDescription() {
        return "push image manifest for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + ":" + this.imageTag;
    }
}

