/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class DockerConfigCredentialRetriever {
    private static final Path DOCKER_CONFIG_FILE = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("config.json");
    private final String registry;
    private final Path dockerConfigFile;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;

    public DockerConfigCredentialRetriever(String registry) {
        this(registry, DOCKER_CONFIG_FILE);
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String registry, Path dockerConfigFile) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
        this.dockerCredentialHelperFactory = new DockerCredentialHelperFactory(registry);
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String registry, Path dockerConfigFile, DockerCredentialHelperFactory dockerCredentialHelperFactory) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
    }

    @Nullable
    public Authorization retrieve() {
        DockerConfigTemplate dockerConfigTemplate = this.loadDockerConfigTemplate();
        if (dockerConfigTemplate == null) {
            return null;
        }
        String auth = dockerConfigTemplate.getAuthFor(this.registry);
        if (auth != null) {
            return Authorizations.withBasicToken(auth);
        }
        String credentialHelperSuffix = dockerConfigTemplate.getCredentialHelperFor(this.registry);
        if (credentialHelperSuffix != null) {
            try {
                return this.dockerCredentialHelperFactory.withCredentialHelperSuffix(credentialHelperSuffix).retrieve();
            }
            catch (NonexistentDockerCredentialHelperException | NonexistentServerUrlDockerCredentialHelperException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private DockerConfigTemplate loadDockerConfigTemplate() {
        if (!Files.exists(this.dockerConfigFile, new LinkOption[0])) {
            return null;
        }
        try {
            return JsonTemplateMapper.readJsonFromFile(this.dockerConfigFile, DockerConfigTemplate.class);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

