/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials.json;

import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class DockerConfigTemplate
extends JsonTemplate {
    private final Map<String, AuthTemplate> auths = new HashMap<String, AuthTemplate>();
    private String credsStore;
    private final Map<String, String> credHelpers = new HashMap<String, String>();

    @Nullable
    public String getAuthFor(String registry) {
        if (!this.auths.containsKey(registry)) {
            return null;
        }
        return this.auths.get(registry).auth;
    }

    @Nullable
    public String getCredentialHelperFor(String registry) {
        if (this.credsStore != null && this.auths.containsKey(registry)) {
            return this.credsStore;
        }
        if (this.credHelpers.containsKey(registry)) {
            return this.credHelpers.get(registry);
        }
        return null;
    }

    @VisibleForTesting
    DockerConfigTemplate addAuth(String registry, @Nullable String auth) {
        AuthTemplate authTemplate = new AuthTemplate();
        authTemplate.auth = auth;
        this.auths.put(registry, authTemplate);
        return this;
    }

    @VisibleForTesting
    DockerConfigTemplate setCredsStore(String credsStore) {
        this.credsStore = credsStore;
        return this;
    }

    @VisibleForTesting
    DockerConfigTemplate addCredHelper(String registry, String credHelper) {
        this.credHelpers.put(registry, credHelper);
        return this;
    }

    private static class AuthTemplate
    extends JsonTemplate {
        private String auth;

        private AuthTemplate() {
        }
    }
}

