/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class PullBaseImageStep
implements Callable<Image> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final Future<Authorization> pullAuthorizationFuture;

    PullBaseImageStep(BuildConfiguration buildConfiguration, Future<Authorization> pullAuthorizationFuture) {
        this.buildConfiguration = buildConfiguration;
        this.pullAuthorizationFuture = pullAuthorizationFuture;
    }

    @Override
    public Image call() throws IOException, RegistryException, LayerPropertyNotFoundException, DuplicateLayerException, LayerCountMismatchException, ExecutionException, InterruptedException {
        Throwable throwable = null;
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            RegistryClient registryClient = new RegistryClient(NonBlockingFutures.get(this.pullAuthorizationFuture), this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
            ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageTag());
            switch (manifestTemplate.getSchemaVersion()) {
                case 1: {
                    V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                    Image image = JsonToImageTranslator.toImage(v21ManifestTemplate);
                    return image;
                }
                case 2: {
                    V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                    ByteArrayOutputStream containerConfigurationOutputStream = new ByteArrayOutputStream();
                    registryClient.pullBlob(v22ManifestTemplate.getContainerConfiguration().getDigest(), containerConfigurationOutputStream);
                    String containerConfigurationString = new String(containerConfigurationOutputStream.toByteArray(), StandardCharsets.UTF_8);
                    ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigurationString, ContainerConfigurationTemplate.class);
                    Image image = JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
                    return image;
                }
            }
            try {
                throw new IllegalStateException("Unknown manifest schema version");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

