/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class PushBlobStep
implements Callable<Void> {
    private static final String DESCRIPTION = "Pushing BLOB ";
    private final BuildConfiguration buildConfiguration;
    private final Future<Authorization> pushAuthorizationFuture;
    private final Future<CachedLayer> pullLayerFuture;

    PushBlobStep(BuildConfiguration buildConfiguration, Future<Authorization> pushAuthorizationFuture, Future<CachedLayer> pullLayerFuture) {
        this.buildConfiguration = buildConfiguration;
        this.pushAuthorizationFuture = pushAuthorizationFuture;
        this.pullLayerFuture = pullLayerFuture;
    }

    @Override
    public Void call() throws IOException, RegistryException, ExecutionException, InterruptedException {
        CachedLayer layer = this.pullLayerFuture.get();
        DescriptorDigest layerDigest = layer.getBlobDescriptor().getDigest();
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION + layerDigest);){
            RegistryClient registryClient = new RegistryClient(this.pushAuthorizationFuture.get(), this.buildConfiguration.getTargetRegistry(), this.buildConfiguration.getTargetRepository()).setTimer(timer);
            if (registryClient.checkBlob(layerDigest) != null) {
                this.buildConfiguration.getBuildLogger().info("BLOB : " + layerDigest + " already exists on registry");
                Void void_ = null;
                return void_;
            }
            registryClient.pushBlob(layerDigest, layer.getBlob());
            Void void_ = null;
            return void_;
        }
    }
}

