/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.NonBlockingFutures;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class PushImageStep
implements Callable<Void> {
    private static final String DESCRIPTION = "Pushing new image";
    private final BuildConfiguration buildConfiguration;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Authorization> pushAuthorizationFuture;
    private final ListenableFuture<List<ListenableFuture<CachedLayer>>> pullBaseImageLayerFuturesFuture;
    private final List<ListenableFuture<CachedLayer>> buildApplicationLayerFutures;
    private final ListenableFuture<List<ListenableFuture<Void>>> pushBaseImageLayerFuturesFuture;
    private final List<ListenableFuture<Void>> pushApplicationLayerFutures;
    private final ListenableFuture<ListenableFuture<BlobDescriptor>> containerConfigurationBlobDescriptorFutureFuture;

    PushImageStep(BuildConfiguration buildConfiguration, ListeningExecutorService listeningExecutorService, ListenableFuture<Authorization> pushAuthorizationFuture, ListenableFuture<List<ListenableFuture<CachedLayer>>> pullBaseImageLayerFuturesFuture, List<ListenableFuture<CachedLayer>> buildApplicationLayerFutures, ListenableFuture<List<ListenableFuture<Void>>> pushBaseImageLayerFuturesFuture, List<ListenableFuture<Void>> pushApplicationLayerFutures, ListenableFuture<ListenableFuture<BlobDescriptor>> containerConfigurationBlobDescriptorFutureFuture) {
        this.buildConfiguration = buildConfiguration;
        this.listeningExecutorService = listeningExecutorService;
        this.pushAuthorizationFuture = pushAuthorizationFuture;
        this.pullBaseImageLayerFuturesFuture = pullBaseImageLayerFuturesFuture;
        this.buildApplicationLayerFutures = buildApplicationLayerFutures;
        this.pushBaseImageLayerFuturesFuture = pushBaseImageLayerFuturesFuture;
        this.pushApplicationLayerFutures = pushApplicationLayerFutures;
        this.containerConfigurationBlobDescriptorFutureFuture = containerConfigurationBlobDescriptorFutureFuture;
    }

    @Override
    public Void call() throws ExecutionException, InterruptedException {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(this.pushAuthorizationFuture);
        dependencies.addAll((Collection)NonBlockingFutures.get(this.pushBaseImageLayerFuturesFuture));
        dependencies.addAll(this.pushApplicationLayerFutures);
        dependencies.add(NonBlockingFutures.get(this.containerConfigurationBlobDescriptorFutureFuture));
        return (Void)Futures.whenAllComplete(dependencies).call(this::afterPushBaseImageLayerFuturesFuture, (Executor)this.listeningExecutorService).get();
    }

    private Void afterPushBaseImageLayerFuturesFuture() throws IOException, RegistryException, ExecutionException, InterruptedException, LayerPropertyNotFoundException, DuplicateLayerException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            RegistryClient registryClient = new RegistryClient(NonBlockingFutures.get(this.pushAuthorizationFuture), this.buildConfiguration.getTargetRegistry(), this.buildConfiguration.getTargetRepository());
            Image image = new Image();
            for (Future future : NonBlockingFutures.get(this.pullBaseImageLayerFuturesFuture)) {
                image.addLayer((Layer)NonBlockingFutures.get(future));
            }
            for (Future future : this.buildApplicationLayerFutures) {
                image.addLayer((Layer)NonBlockingFutures.get(future));
            }
            ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(image);
            BuildableManifestTemplate buildableManifestTemplate = imageToJsonTranslator.getManifestTemplate(this.buildConfiguration.getTargetFormat(), (BlobDescriptor)NonBlockingFutures.get((Future)NonBlockingFutures.get(this.containerConfigurationBlobDescriptorFutureFuture)));
            registryClient.pushManifest(buildableManifestTemplate, this.buildConfiguration.getTargetTag());
        }
        return null;
    }
}

