/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildConfiguration buildConfiguration;
    private final String registry;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;

    RetrieveRegistryCredentialsStep(BuildConfiguration buildConfiguration, String registry) {
        this(buildConfiguration, registry, new DockerCredentialHelperFactory(registry), new DockerConfigCredentialRetriever(registry));
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(BuildConfiguration buildConfiguration, String registry, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildConfiguration = buildConfiguration;
        this.registry = registry;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
    }

    @Override
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getTargetRegistry()));){
            Object object;
            for (String credentialHelperSuffix : this.buildConfiguration.getCredentialHelperNames()) {
                Authorization authorization = this.retrieveFromCredentialHelper(credentialHelperSuffix);
                if (authorization == null) continue;
                Authorization authorization2 = authorization;
                return authorization2;
            }
            if (this.buildConfiguration.getKnownRegistryCredentials().has(this.registry)) {
                this.logGotCredentialsFrom(this.buildConfiguration.getKnownRegistryCredentials().getCredentialSource(this.registry));
                Authorization authorization = this.buildConfiguration.getKnownRegistryCredentials().getAuthorization(this.registry);
                return authorization;
            }
            Authorization dockerConfigAuthorization = this.dockerConfigCredentialRetriever.retrieve();
            if (dockerConfigAuthorization != null) {
                this.buildConfiguration.getBuildLogger().info("Using credentials from Docker config for " + this.registry);
                object = dockerConfigAuthorization;
                return object;
            }
            for (String registrySuffix : COMMON_CREDENTIAL_HELPERS.keySet()) {
                if (!this.registry.endsWith(registrySuffix)) continue;
                try {
                    Authorization authorization = this.retrieveFromCredentialHelper((String)COMMON_CREDENTIAL_HELPERS.get((Object)registrySuffix));
                    if (authorization == null) continue;
                    Authorization authorization3 = authorization;
                    return authorization3;
                }
                catch (NonexistentDockerCredentialHelperException ex) {
                    this.buildConfiguration.getBuildLogger().warn(ex.getMessage());
                }
            }
            this.buildConfiguration.getBuildLogger().info("No credentials could be retrieved for registry " + this.registry);
            object = null;
            return object;
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String credentialHelperSuffix) throws NonexistentDockerCredentialHelperException, IOException {
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.withCredentialHelperSuffix(credentialHelperSuffix).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + credentialHelperSuffix);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException ex) {
            return null;
        }
    }

    private void logGotCredentialsFrom(String credentialSource) {
        this.buildConfiguration.getBuildLogger().info("Using " + credentialSource + " for " + this.registry);
    }
}

