/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CacheMetadata {
    private final ImageLayers<CachedLayerWithMetadata> layers = new ImageLayers();

    CacheMetadata() {
    }

    ImageLayers<CachedLayerWithMetadata> getLayers() {
        return this.layers;
    }

    synchronized void addLayer(CachedLayerWithMetadata layer) throws LayerPropertyNotFoundException, DuplicateLayerException {
        this.layers.add(layer);
    }

    LayerFilter filterLayers() {
        return new LayerFilter(this.layers);
    }

    static class LayerFilter {
        private final ImageLayers<CachedLayerWithMetadata> layers;
        @Nullable
        private List<Path> sourceFiles;

        private LayerFilter(ImageLayers<CachedLayerWithMetadata> layers) {
            this.layers = layers;
        }

        LayerFilter bySourceFiles(List<Path> sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        ImageLayers<CachedLayerWithMetadata> filter() throws CacheMetadataCorruptedException {
            try {
                ImageLayers<CachedLayerWithMetadata> filteredLayers = new ImageLayers<CachedLayerWithMetadata>();
                for (CachedLayerWithMetadata layer : this.layers) {
                    if (this.sourceFiles != null) {
                        if (layer.getMetadata() == null) continue;
                        List<String> cachedLayerSourceFilePaths = layer.getMetadata().getSourceFiles();
                        if (cachedLayerSourceFilePaths != null) {
                            ArrayList<Path> cachedLayerSourceFiles = new ArrayList<Path>();
                            for (String sourceFile : cachedLayerSourceFilePaths) {
                                cachedLayerSourceFiles.add(Paths.get(sourceFile, new String[0]));
                            }
                            if (!cachedLayerSourceFiles.equals(this.sourceFiles)) continue;
                        }
                    }
                    filteredLayers.add(layer);
                }
                return filteredLayers;
            }
            catch (DuplicateLayerException | LayerPropertyNotFoundException ex) {
                throw new CacheMetadataCorruptedException(ex);
            }
        }
    }
}

