/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerPropertiesObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import java.nio.file.Path;

public class CacheMetadataTranslator {
    static CacheMetadata fromTemplate(CacheMetadataTemplate template, Path cacheDirectory) throws CacheMetadataCorruptedException {
        try {
            CacheMetadata cacheMetadata = new CacheMetadata();
            for (CacheMetadataLayerObjectTemplate layerObjectTemplate : template.getLayers()) {
                Path layerContentFile = CacheFiles.getLayerFile(cacheDirectory, layerObjectTemplate.getDigest());
                CacheMetadataLayerPropertiesObjectTemplate propertiesObjectTemplate = layerObjectTemplate.getProperties();
                LayerMetadata layerMetadata = null;
                if (propertiesObjectTemplate != null) {
                    layerMetadata = new LayerMetadata(propertiesObjectTemplate.getSourceFiles(), propertiesObjectTemplate.getLastModifiedTime());
                }
                CachedLayer cachedLayer = new CachedLayer(layerContentFile, new BlobDescriptor(layerObjectTemplate.getSize(), layerObjectTemplate.getDigest()), layerObjectTemplate.getDiffId());
                CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata(cachedLayer, layerMetadata);
                cacheMetadata.addLayer(cachedLayerWithMetadata);
            }
            return cacheMetadata;
        }
        catch (DuplicateLayerException | LayerPropertyNotFoundException ex) {
            throw new CacheMetadataCorruptedException(ex);
        }
    }

    static CacheMetadataTemplate toTemplate(CacheMetadata cacheMetadata) {
        CacheMetadataTemplate template = new CacheMetadataTemplate();
        for (CachedLayerWithMetadata cachedLayerWithMetadata : cacheMetadata.getLayers()) {
            CacheMetadataLayerObjectTemplate layerObjectTemplate = new CacheMetadataLayerObjectTemplate().setSize(cachedLayerWithMetadata.getBlobDescriptor().getSize()).setDigest(cachedLayerWithMetadata.getBlobDescriptor().getDigest()).setDiffId(cachedLayerWithMetadata.getDiffId());
            if (cachedLayerWithMetadata.getMetadata() != null) {
                layerObjectTemplate.setProperties(new CacheMetadataLayerPropertiesObjectTemplate().setSourceFiles(cachedLayerWithMetadata.getMetadata().getSourceFiles()).setLastModifiedTime(cachedLayerWithMetadata.getMetadata().getLastModifiedTime()));
            }
            template.addLayer(layerObjectTemplate);
        }
        return template;
    }
}

