/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.DuplicateLayerException;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Image {
    private ImageLayers<Layer> layers = new ImageLayers();
    private final List<String> environment = new ArrayList<String>();
    private List<String> entrypoint;

    public List<String> getEnvironment() {
        return Collections.unmodifiableList(this.environment);
    }

    public Image setEnvironment(Map<String, String> environment) {
        for (Map.Entry<String, String> environmentVariable : environment.entrySet()) {
            this.setEnvironmentVariable(environmentVariable.getKey(), environmentVariable.getValue());
        }
        return this;
    }

    public Image setEnvironmentVariable(String name, String value) {
        this.environment.add(name + "=" + value);
        return this;
    }

    public Image addEnvironmentVariableDefinition(String environmentVariableDefinition) {
        this.environment.add(environmentVariableDefinition);
        return this;
    }

    public List<String> getEntrypoint() {
        return Collections.unmodifiableList(this.entrypoint);
    }

    public Image setEntrypoint(List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public List<Layer> getLayers() {
        return this.layers.getLayers();
    }

    public Image addLayer(Layer layer) throws DuplicateLayerException, LayerPropertyNotFoundException {
        this.layers.add(layer);
        return this;
    }

    public <T extends Layer> Image addLayers(ImageLayers<T> layers) throws LayerPropertyNotFoundException, DuplicateLayerException {
        this.layers.addAll(layers);
        return this;
    }
}

